/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.packetlib.AbstractServer;
import com.github.steveice10.packetlib.helper.TransportHelper;
import com.github.steveice10.packetlib.packet.PacketProtocol;
import com.github.steveice10.packetlib.tcp.TcpPacketCodec;
import com.github.steveice10.packetlib.tcp.TcpPacketSizer;
import com.github.steveice10.packetlib.tcp.TcpServerSession;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.function.Supplier;

public class TcpServer
extends AbstractServer {
    private EventLoopGroup group;
    private Class<? extends ServerSocketChannel> serverSocketChannel;
    private Channel channel;

    public TcpServer(String host, int port, Supplier<? extends PacketProtocol> protocol) {
        super(host, port, protocol);
    }

    @Override
    public boolean isListening() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void bindImpl(boolean wait, Runnable callback) {
        if (this.group != null || this.channel != null) {
            return;
        }
        switch (TransportHelper.determineTransportMethod()) {
            case IO_URING: {
                this.group = new IOUringEventLoopGroup();
                this.serverSocketChannel = IOUringServerSocketChannel.class;
                break;
            }
            case EPOLL: {
                this.group = new EpollEventLoopGroup();
                this.serverSocketChannel = EpollServerSocketChannel.class;
                break;
            }
            case NIO: {
                this.group = new NioEventLoopGroup();
                this.serverSocketChannel = NioServerSocketChannel.class;
            }
        }
        ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(this.serverSocketChannel)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel channel) {
                InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
                PacketProtocol protocol = TcpServer.this.createPacketProtocol();
                TcpServerSession session = new TcpServerSession(address.getHostName(), address.getPort(), protocol, TcpServer.this);
                session.getPacketProtocol().newServerSession(TcpServer.this, session);
                channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline pipeline = channel.pipeline();
                session.refreshReadTimeoutHandler(channel);
                session.refreshWriteTimeoutHandler(channel);
                int size = protocol.getPacketHeader().getLengthSize();
                if (size > 0) {
                    pipeline.addLast("sizer", (ChannelHandler)new TcpPacketSizer(session, size));
                }
                pipeline.addLast("codec", (ChannelHandler)new TcpPacketCodec(session, false));
                pipeline.addLast("manager", (ChannelHandler)session);
            }
        }).group(this.group).localAddress(this.getHost(), this.getPort())).bind();
        if (wait) {
            try {
                future.sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.channel = future.channel();
            if (callback != null) {
                callback.run();
            }
        } else {
            future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                if (future1.isSuccess()) {
                    this.channel = future1.channel();
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    System.err.println("[ERROR] Failed to asynchronously bind connection listener.");
                    if (future1.cause() != null) {
                        future1.cause().printStackTrace();
                    }
                }
            }));
        }
    }

    @Override
    public void closeImpl(boolean wait, Runnable callback) {
        Future future;
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                future = this.channel.close();
                if (wait) {
                    try {
                        future.sync();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
                        if (future1.isSuccess()) {
                            if (callback != null) {
                                callback.run();
                            }
                        } else {
                            System.err.println("[ERROR] Failed to asynchronously close connection listener.");
                            if (future1.cause() != null) {
                                future1.cause().printStackTrace();
                            }
                        }
                    }));
                }
            }
            this.channel = null;
        }
        if (this.group != null) {
            future = this.group.shutdownGracefully();
            if (wait) {
                try {
                    future.sync();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                future.addListener(new GenericFutureListener(){

                    public void operationComplete(Future future) {
                        if (!future.isSuccess() && TcpServer.this.getGlobalFlag("print-packetlib-debug", false).booleanValue()) {
                            System.err.println("[ERROR] Failed to asynchronously close connection listener.");
                            if (future.cause() != null) {
                                future.cause().printStackTrace();
                            }
                        }
                    }
                });
            }
            this.group = null;
        }
    }
}

