/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.packet;

import com.github.steveice10.packetlib.Server;
import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.packet.BufferedPacket;
import com.github.steveice10.packetlib.packet.Packet;
import com.github.steveice10.packetlib.packet.PacketDefinition;
import com.github.steveice10.packetlib.packet.PacketFactory;
import com.github.steveice10.packetlib.packet.PacketHeader;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class PacketProtocol {
    private final Map<Integer, PacketDefinition<? extends Packet>> serverbound = new HashMap<Integer, PacketDefinition<? extends Packet>>();
    private final Map<Integer, PacketDefinition<? extends Packet>> clientbound = new HashMap<Integer, PacketDefinition<? extends Packet>>();
    private final Map<Class<? extends Packet>, Integer> clientboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();
    private final Map<Class<? extends Packet>, Integer> serverboundIds = new IdentityHashMap<Class<? extends Packet>, Integer>();

    public abstract String getSRVRecordPrefix();

    public abstract PacketHeader getPacketHeader();

    public abstract void newClientSession(Session var1);

    public abstract void newServerSession(Server var1, Session var2);

    public final void clearPackets() {
        this.serverbound.clear();
        this.clientbound.clear();
        this.clientboundIds.clear();
        this.serverboundIds.clear();
    }

    public final <T extends Packet> void register(int id, Class<T> packet, PacketFactory<T> factory) {
        this.registerServerbound(id, packet, factory);
        this.registerClientbound(id, packet, factory);
    }

    public final void register(PacketDefinition<? extends Packet> definition) {
        this.registerServerbound(definition);
        this.registerClientbound(definition);
    }

    public final <T extends Packet> void registerServerbound(int id, Class<T> packet, PacketFactory<T> factory) {
        this.registerServerbound(new PacketDefinition<T>(id, packet, factory));
    }

    public final void registerServerbound(PacketDefinition<? extends Packet> definition) {
        this.serverbound.put(definition.getId(), definition);
        this.serverboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public final <T extends Packet> void registerClientbound(int id, Class<T> packet, PacketFactory<T> factory) {
        this.registerClientbound(new PacketDefinition<T>(id, packet, factory));
    }

    public final void registerClientbound(PacketDefinition<? extends Packet> definition) {
        this.clientbound.put(definition.getId(), definition);
        this.clientboundIds.put(definition.getPacketClass(), definition.getId());
    }

    public Packet createClientboundPacket(int id, NetInput in) throws IOException {
        PacketDefinition<? extends Packet> definition = this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getFactory().construct(in);
    }

    public int getClientboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.clientboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered clientbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getClientboundId(Packet packet) {
        if (packet instanceof BufferedPacket) {
            return this.getClientboundId(((BufferedPacket)packet).getPacketClass());
        }
        return this.getClientboundId(packet.getClass());
    }

    public Class<? extends Packet> getClientboundClass(int id) {
        PacketDefinition<? extends Packet> definition = this.clientbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }

    public Packet createServerboundPacket(int id, NetInput in) throws IOException {
        PacketDefinition<? extends Packet> definition = this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getFactory().construct(in);
    }

    public int getServerboundId(Class<? extends Packet> packetClass) {
        Integer packetId = this.serverboundIds.get(packetClass);
        if (packetId == null) {
            throw new IllegalArgumentException("Unregistered serverbound packet class: " + packetClass.getName());
        }
        return packetId;
    }

    public int getServerboundId(Packet packet) {
        if (packet instanceof BufferedPacket) {
            return this.getServerboundId(((BufferedPacket)packet).getPacketClass());
        }
        return this.getServerboundId(packet.getClass());
    }

    public Class<? extends Packet> getServerboundClass(int id) {
        PacketDefinition<? extends Packet> definition = this.serverbound.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Invalid packet id: " + id);
        }
        return definition.getPacketClass();
    }
}

