/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.packet;

import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import com.github.steveice10.packetlib.packet.PacketHeader;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class DefaultPacketHeader
implements PacketHeader {
    @Override
    public boolean isLengthVariable() {
        return true;
    }

    @Override
    public int getLengthSize() {
        return 5;
    }

    @Override
    public int getLengthSize(int length) {
        if ((length & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((length & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((length & 0xFFE00000) == 0) {
            return 3;
        }
        if ((length & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    @Override
    public int readLength(ByteBuf buf, PacketCodecHelper codecHelper, int available) throws IOException {
        return codecHelper.readVarInt(buf);
    }

    @Override
    public void writeLength(ByteBuf buf, PacketCodecHelper codecHelper, int length) throws IOException {
        codecHelper.writeVarInt(buf, length);
    }

    @Override
    public int readPacketId(ByteBuf buf, PacketCodecHelper codecHelper) throws IOException {
        return codecHelper.readVarInt(buf);
    }

    @Override
    public void writePacketId(ByteBuf buf, PacketCodecHelper codecHelper, int packetId) throws IOException {
        codecHelper.writeVarInt(buf, packetId);
    }
}

