/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.codec;

import com.github.steveice10.packetlib.codec.PacketCodecHelper;
import com.github.steveice10.packetlib.codec.PacketSerializer;
import com.github.steveice10.packetlib.packet.Packet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class PacketDefinition<T extends Packet, H extends PacketCodecHelper> {
    private final int id;
    private final Class<T> packetClass;
    private final PacketSerializer<T, H> serializer;

    public PacketDefinition(int id, Class<T> packetClass, PacketSerializer<T, H> serializer) {
        this.id = id;
        this.packetClass = packetClass;
        this.serializer = serializer;
    }

    public int getId() {
        return this.id;
    }

    public Class<T> getPacketClass() {
        return this.packetClass;
    }

    public PacketSerializer<T, H> getSerializer() {
        return this.serializer;
    }

    public T newInstance(ByteBuf buf, H helper) throws IOException {
        return this.serializer.deserialize(buf, helper, this);
    }
}

