/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.level.block.ExplosionInteraction;
import com.github.steveice10.mc.protocol.data.game.level.particle.Particle;
import com.github.steveice10.mc.protocol.data.game.level.sound.Sound;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.cloudburstmc.math.vector.Vector3i;

public class ClientboundExplodePacket
implements MinecraftPacket {
    private final double x;
    private final double y;
    private final double z;
    private final float radius;
    @NonNull
    private final List<Vector3i> exploded;
    private final float pushX;
    private final float pushY;
    private final float pushZ;
    @NonNull
    private final Particle smallExplosionParticles;
    @NonNull
    private final Particle largeExplosionParticles;
    @NonNull
    private final ExplosionInteraction blockInteraction;
    @NonNull
    private final Sound explosionSound;

    public ClientboundExplodePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.radius = in.readFloat();
        this.exploded = new ArrayList<Vector3i>();
        int length = helper.readVarInt(in);
        for (int count = 0; count < length; ++count) {
            this.exploded.add(Vector3i.from((int)in.readByte(), (int)in.readByte(), (int)in.readByte()));
        }
        this.pushX = in.readFloat();
        this.pushY = in.readFloat();
        this.pushZ = in.readFloat();
        this.blockInteraction = ExplosionInteraction.from(helper.readVarInt(in));
        this.smallExplosionParticles = helper.readParticle(in);
        this.largeExplosionParticles = helper.readParticle(in);
        this.explosionSound = helper.readSoundEvent(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.radius);
        helper.writeVarInt(out, this.exploded.size());
        for (Vector3i record : this.exploded) {
            out.writeByte(record.getX());
            out.writeByte(record.getY());
            out.writeByte(record.getZ());
        }
        out.writeFloat(this.pushX);
        out.writeFloat(this.pushY);
        out.writeFloat(this.pushZ);
        helper.writeVarInt(out, this.blockInteraction.ordinal());
        helper.writeParticle(out, this.smallExplosionParticles);
        helper.writeParticle(out, this.largeExplosionParticles);
        helper.writeSoundEvent(out, this.explosionSound);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getRadius() {
        return this.radius;
    }

    @NonNull
    public List<Vector3i> getExploded() {
        return this.exploded;
    }

    public float getPushX() {
        return this.pushX;
    }

    public float getPushY() {
        return this.pushY;
    }

    public float getPushZ() {
        return this.pushZ;
    }

    @NonNull
    public Particle getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    @NonNull
    public Particle getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    @NonNull
    public ExplosionInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    @NonNull
    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundExplodePacket)) {
            return false;
        }
        ClientboundExplodePacket other = (ClientboundExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushX(), other.getPushX()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushY(), other.getPushY()) != 0) {
            return false;
        }
        if (Float.compare(this.getPushZ(), other.getPushZ()) != 0) {
            return false;
        }
        List<Vector3i> this$exploded = this.getExploded();
        List<Vector3i> other$exploded = other.getExploded();
        if (this$exploded == null ? other$exploded != null : !((Object)this$exploded).equals(other$exploded)) {
            return false;
        }
        Particle this$smallExplosionParticles = this.getSmallExplosionParticles();
        Particle other$smallExplosionParticles = other.getSmallExplosionParticles();
        if (this$smallExplosionParticles == null ? other$smallExplosionParticles != null : !((Object)this$smallExplosionParticles).equals(other$smallExplosionParticles)) {
            return false;
        }
        Particle this$largeExplosionParticles = this.getLargeExplosionParticles();
        Particle other$largeExplosionParticles = other.getLargeExplosionParticles();
        if (this$largeExplosionParticles == null ? other$largeExplosionParticles != null : !((Object)this$largeExplosionParticles).equals(other$largeExplosionParticles)) {
            return false;
        }
        ExplosionInteraction this$blockInteraction = this.getBlockInteraction();
        ExplosionInteraction other$blockInteraction = other.getBlockInteraction();
        if (this$blockInteraction == null ? other$blockInteraction != null : !((Object)((Object)this$blockInteraction)).equals((Object)other$blockInteraction)) {
            return false;
        }
        Sound this$explosionSound = this.getExplosionSound();
        Sound other$explosionSound = other.getExplosionSound();
        return !(this$explosionSound == null ? other$explosionSound != null : !this$explosionSound.equals(other$explosionSound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + Float.floatToIntBits(this.getPushX());
        result = result * 59 + Float.floatToIntBits(this.getPushY());
        result = result * 59 + Float.floatToIntBits(this.getPushZ());
        List<Vector3i> $exploded = this.getExploded();
        result = result * 59 + ($exploded == null ? 43 : ((Object)$exploded).hashCode());
        Particle $smallExplosionParticles = this.getSmallExplosionParticles();
        result = result * 59 + ($smallExplosionParticles == null ? 43 : ((Object)$smallExplosionParticles).hashCode());
        Particle $largeExplosionParticles = this.getLargeExplosionParticles();
        result = result * 59 + ($largeExplosionParticles == null ? 43 : ((Object)$largeExplosionParticles).hashCode());
        ExplosionInteraction $blockInteraction = this.getBlockInteraction();
        result = result * 59 + ($blockInteraction == null ? 43 : ((Object)((Object)$blockInteraction)).hashCode());
        Sound $explosionSound = this.getExplosionSound();
        result = result * 59 + ($explosionSound == null ? 43 : $explosionSound.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundExplodePacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", radius=" + this.getRadius() + ", exploded=" + this.getExploded() + ", pushX=" + this.getPushX() + ", pushY=" + this.getPushY() + ", pushZ=" + this.getPushZ() + ", smallExplosionParticles=" + this.getSmallExplosionParticles() + ", largeExplosionParticles=" + this.getLargeExplosionParticles() + ", blockInteraction=" + this.getBlockInteraction() + ", explosionSound=" + this.getExplosionSound() + ")";
    }

    public ClientboundExplodePacket withX(double x) {
        return this.x == x ? this : new ClientboundExplodePacket(x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withY(double y) {
        return this.y == y ? this : new ClientboundExplodePacket(this.x, y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withZ(double z) {
        return this.z == z ? this : new ClientboundExplodePacket(this.x, this.y, z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withRadius(float radius) {
        return this.radius == radius ? this : new ClientboundExplodePacket(this.x, this.y, this.z, radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withExploded(@NonNull List<Vector3i> exploded) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        return this.exploded == exploded ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withPushX(float pushX) {
        return this.pushX == pushX ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withPushY(float pushY) {
        return this.pushY == pushY ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withPushZ(float pushZ) {
        return this.pushZ == pushZ ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withSmallExplosionParticles(@NonNull Particle smallExplosionParticles) {
        if (smallExplosionParticles == null) {
            throw new NullPointerException("smallExplosionParticles is marked non-null but is null");
        }
        return this.smallExplosionParticles == smallExplosionParticles ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withLargeExplosionParticles(@NonNull Particle largeExplosionParticles) {
        if (largeExplosionParticles == null) {
            throw new NullPointerException("largeExplosionParticles is marked non-null but is null");
        }
        return this.largeExplosionParticles == largeExplosionParticles ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, largeExplosionParticles, this.blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withBlockInteraction(@NonNull ExplosionInteraction blockInteraction) {
        if (blockInteraction == null) {
            throw new NullPointerException("blockInteraction is marked non-null but is null");
        }
        return this.blockInteraction == blockInteraction ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, blockInteraction, this.explosionSound);
    }

    public ClientboundExplodePacket withExplosionSound(@NonNull Sound explosionSound) {
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        return this.explosionSound == explosionSound ? this : new ClientboundExplodePacket(this.x, this.y, this.z, this.radius, this.exploded, this.pushX, this.pushY, this.pushZ, this.smallExplosionParticles, this.largeExplosionParticles, this.blockInteraction, explosionSound);
    }

    public ClientboundExplodePacket(double x, double y, double z, float radius, @NonNull List<Vector3i> exploded, float pushX, float pushY, float pushZ, @NonNull Particle smallExplosionParticles, @NonNull Particle largeExplosionParticles, @NonNull ExplosionInteraction blockInteraction, @NonNull Sound explosionSound) {
        if (exploded == null) {
            throw new NullPointerException("exploded is marked non-null but is null");
        }
        if (smallExplosionParticles == null) {
            throw new NullPointerException("smallExplosionParticles is marked non-null but is null");
        }
        if (largeExplosionParticles == null) {
            throw new NullPointerException("largeExplosionParticles is marked non-null but is null");
        }
        if (blockInteraction == null) {
            throw new NullPointerException("blockInteraction is marked non-null but is null");
        }
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
        this.exploded = exploded;
        this.pushX = pushX;
        this.pushY = pushY;
        this.pushZ = pushZ;
        this.smallExplosionParticles = smallExplosionParticles;
        this.largeExplosionParticles = largeExplosionParticles;
        this.blockInteraction = blockInteraction;
        this.explosionSound = explosionSound;
    }
}

