/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.level.block.WobbleStyle;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BellValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BellValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.BlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.ChestValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.ChestValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.DecoratedPotValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.DecoratedPotValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.EndGatewayValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.EndGatewayValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.GenericBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.GenericBlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.MobSpawnerValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.MobSpawnerValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.NoteBlockValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.NoteBlockValueType;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValue;
import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValueType;
import io.netty.buffer.ByteBuf;
import lombok.NonNull;
import org.cloudburstmc.math.vector.Vector3i;

public class ClientboundBlockEventPacket
implements MinecraftPacket {
    private static final int NOTE_BLOCK = 102;
    private static final int STICKY_PISTON = 121;
    private static final int PISTON = 128;
    private static final int MOB_SPAWNER = 175;
    private static final int CHEST = 177;
    private static final int ENDER_CHEST = 344;
    private static final int TRAPPED_CHEST = 411;
    private static final int END_GATEWAY = 603;
    private static final int SHULKER_BOX_LOWER = 613;
    private static final int SHULKER_BOX_HIGHER = 629;
    private static final int BELL = 783;
    private static final int DECORATED_POT = 1055;
    @NonNull
    private final Vector3i position;
    @NonNull
    private final BlockValueType type;
    @NonNull
    private final BlockValue value;
    private final int blockId;

    public ClientboundBlockEventPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = helper.readPosition(in);
        short type = in.readUnsignedByte();
        short value = in.readUnsignedByte();
        this.blockId = helper.readVarInt(in);
        if (this.blockId == 102) {
            this.type = NoteBlockValueType.from(type);
            this.value = new NoteBlockValue();
        } else if (this.blockId == 121 || this.blockId == 128) {
            this.type = PistonValueType.from(type);
            this.value = new PistonValue(Direction.from(Math.abs((value & 7) % 6)));
        } else if (this.blockId == 175) {
            this.type = MobSpawnerValueType.from(type - 1);
            this.value = new MobSpawnerValue();
        } else if (this.blockId == 177 || this.blockId == 344 || this.blockId == 411 || this.blockId >= 613 && this.blockId <= 629) {
            this.type = ChestValueType.from(type - 1);
            this.value = new ChestValue(value);
        } else if (this.blockId == 603) {
            this.type = EndGatewayValueType.from(type - 1);
            this.value = new EndGatewayValue();
        } else if (this.blockId == 783) {
            this.type = BellValueType.from(type - 1);
            this.value = new BellValue(Direction.from(Math.abs(value % 6)));
        } else if (this.blockId == 1055) {
            this.type = DecoratedPotValueType.from(type - 1);
            this.value = new DecoratedPotValue(WobbleStyle.from(Math.abs(value % 2)));
        } else {
            this.type = GenericBlockValueType.from(type);
            this.value = new GenericBlockValue(value);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        int val = 0;
        int type = 0;
        if (this.type instanceof PistonValueType) {
            val = ((PistonValue)this.value).getDirection().ordinal();
            type = ((PistonValueType)this.type).ordinal();
        } else if (this.type instanceof MobSpawnerValueType) {
            type = ((MobSpawnerValueType)this.type).ordinal() + 1;
        } else if (this.type instanceof ChestValueType) {
            val = ((ChestValue)this.value).getViewers();
            type = ((ChestValueType)this.type).ordinal() + 1;
        } else if (this.type instanceof EndGatewayValueType) {
            type = ((EndGatewayValueType)this.type).ordinal() + 1;
        } else if (this.type instanceof BellValueType) {
            val = ((BellValue)this.value).getDirection().ordinal();
            type = ((BellValueType)this.type).ordinal() + 1;
        } else if (this.type instanceof GenericBlockValueType) {
            val = ((GenericBlockValue)this.value).getValue();
            type = ((GenericBlockValueType)this.type).ordinal();
        }
        helper.writePosition(out, this.position);
        out.writeByte(type);
        out.writeByte(val);
        helper.writeVarInt(out, this.blockId);
    }

    @NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @NonNull
    public BlockValueType getType() {
        return this.type;
    }

    @NonNull
    public BlockValue getValue() {
        return this.value;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockEventPacket)) {
            return false;
        }
        ClientboundBlockEventPacket other = (ClientboundBlockEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockId() != other.getBlockId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockValueType this$type = this.getType();
        BlockValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BlockValue this$value = this.getValue();
        BlockValue other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBlockEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockId();
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BlockValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBlockEventPacket(position=" + this.getPosition() + ", type=" + this.getType() + ", value=" + this.getValue() + ", blockId=" + this.getBlockId() + ")";
    }

    public ClientboundBlockEventPacket withPosition(@NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockEventPacket(position, this.type, this.value, this.blockId);
    }

    public ClientboundBlockEventPacket withType(@NonNull BlockValueType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundBlockEventPacket(this.position, type, this.value, this.blockId);
    }

    public ClientboundBlockEventPacket withValue(@NonNull BlockValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.value == value ? this : new ClientboundBlockEventPacket(this.position, this.type, value, this.blockId);
    }

    public ClientboundBlockEventPacket withBlockId(int blockId) {
        return this.blockId == blockId ? this : new ClientboundBlockEventPacket(this.position, this.type, this.value, blockId);
    }

    public ClientboundBlockEventPacket(@NonNull Vector3i position, @NonNull BlockValueType type, @NonNull BlockValue value, int blockId) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.value = value;
        this.blockId = blockId;
    }
}

