/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundOpenScreenPacket
implements MinecraftPacket {
    private final int containerId;
    @NonNull
    private final ContainerType type;
    @NonNull
    private final Component title;

    public ClientboundOpenScreenPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.containerId = helper.readVarInt(in);
        this.type = ContainerType.from(helper.readVarInt(in));
        this.title = helper.readComponent(in);
    }

    @Deprecated
    public ClientboundOpenScreenPacket(int containerId, @NonNull ContainerType type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.containerId = containerId;
        this.type = type;
        this.title = DefaultComponentSerializer.get().deserialize((Object)name);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.containerId);
        helper.writeVarInt(out, this.type.ordinal());
        helper.writeComponent(out, this.title);
    }

    @Deprecated
    public String getName() {
        return (String)DefaultComponentSerializer.get().serialize(this.title);
    }

    @Deprecated
    public ClientboundOpenScreenPacket withName(String name) {
        return new ClientboundOpenScreenPacket(this.containerId, this.type, DefaultComponentSerializer.get().deserialize((Object)name));
    }

    public int getContainerId() {
        return this.containerId;
    }

    @NonNull
    public ContainerType getType() {
        return this.type;
    }

    @NonNull
    public Component getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundOpenScreenPacket)) {
            return false;
        }
        ClientboundOpenScreenPacket other = (ClientboundOpenScreenPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        ContainerType this$type = this.getType();
        ContainerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Component this$title = this.getTitle();
        Component other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundOpenScreenPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        ContainerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Component $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundOpenScreenPacket(containerId=" + this.getContainerId() + ", type=" + this.getType() + ", title=" + this.getTitle() + ")";
    }

    public ClientboundOpenScreenPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundOpenScreenPacket(containerId, this.type, this.title);
    }

    public ClientboundOpenScreenPacket withType(@NonNull ContainerType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundOpenScreenPacket(this.containerId, type, this.title);
    }

    public ClientboundOpenScreenPacket withTitle(@NonNull Component title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        return this.title == title ? this : new ClientboundOpenScreenPacket(this.containerId, this.type, title);
    }

    public ClientboundOpenScreenPacket(int containerId, @NonNull ContainerType type, @NonNull Component title) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.containerId = containerId;
        this.type = type;
        this.title = title;
    }
}

