/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ClientboundRemoveEntitiesPacket
implements MinecraftPacket {
    @NotNull
    private final int[] entityIds;

    public ClientboundRemoveEntitiesPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityIds = new int[helper.readVarInt(in)];
        for (int i = 0; i < this.entityIds.length; ++i) {
            this.entityIds[i] = helper.readVarInt(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityIds.length);
        for (int entityId : this.entityIds) {
            helper.writeVarInt(out, entityId);
        }
    }

    @NotNull
    public int[] getEntityIds() {
        return this.entityIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRemoveEntitiesPacket)) {
            return false;
        }
        ClientboundRemoveEntitiesPacket other = (ClientboundRemoveEntitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getEntityIds(), other.getEntityIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRemoveEntitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getEntityIds());
        return result;
    }

    public String toString() {
        return "ClientboundRemoveEntitiesPacket(entityIds=" + Arrays.toString(this.getEntityIds()) + ")";
    }

    public ClientboundRemoveEntitiesPacket withEntityIds(@NotNull int[] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        return this.entityIds == entityIds ? this : new ClientboundRemoveEntitiesPacket(entityIds);
    }

    public ClientboundRemoveEntitiesPacket(@NotNull int[] entityIds) {
        if (entityIds == null) {
            throw new NullPointerException("entityIds is marked non-null but is null");
        }
        this.entityIds = entityIds;
    }
}

