/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundCooldownPacket
implements MinecraftPacket {
    private final int itemId;
    private final int cooldownTicks;

    public ClientboundCooldownPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.itemId = helper.readVarInt(in);
        this.cooldownTicks = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.itemId);
        helper.writeVarInt(out, this.cooldownTicks);
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCooldownPacket)) {
            return false;
        }
        ClientboundCooldownPacket other = (ClientboundCooldownPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        return this.getCooldownTicks() == other.getCooldownTicks();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundCooldownPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getItemId();
        result = result * 59 + this.getCooldownTicks();
        return result;
    }

    public String toString() {
        return "ClientboundCooldownPacket(itemId=" + this.getItemId() + ", cooldownTicks=" + this.getCooldownTicks() + ")";
    }

    public ClientboundCooldownPacket withItemId(int itemId) {
        return this.itemId == itemId ? this : new ClientboundCooldownPacket(itemId, this.cooldownTicks);
    }

    public ClientboundCooldownPacket withCooldownTicks(int cooldownTicks) {
        return this.cooldownTicks == cooldownTicks ? this : new ClientboundCooldownPacket(this.itemId, cooldownTicks);
    }

    public ClientboundCooldownPacket(int itemId, int cooldownTicks) {
        this.itemId = itemId;
        this.cooldownTicks = cooldownTicks;
    }
}

