/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.level.event;

import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEventData;
import java.util.EnumSet;
import java.util.Set;

public final class SculkBlockChargeEventData
implements LevelEventData {
    private final int charge;
    private final Set<Direction> blockFaces;

    public SculkBlockChargeEventData(int charge, Set<Direction> blockFaces) {
        this.charge = charge;
        this.blockFaces = blockFaces;
    }

    public SculkBlockChargeEventData(int value) {
        this.charge = value >> 6;
        this.blockFaces = EnumSet.noneOf(Direction.class);
        int blockFaceBits = value & 0x3F;
        for (Direction direction : Direction.VALUES) {
            if ((blockFaceBits >> direction.ordinal() & 1) != 1) continue;
            this.blockFaces.add(direction);
        }
    }

    public int getLevelValue() {
        int value = this.charge << 6;
        for (Direction direction : this.blockFaces) {
            value |= 1 << direction.ordinal();
        }
        return value;
    }

    public int getCharge() {
        return this.charge;
    }

    public Set<Direction> getBlockFaces() {
        return this.blockFaces;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SculkBlockChargeEventData)) {
            return false;
        }
        SculkBlockChargeEventData other = (SculkBlockChargeEventData)o;
        if (this.getCharge() != other.getCharge()) {
            return false;
        }
        Set<Direction> this$blockFaces = this.getBlockFaces();
        Set<Direction> other$blockFaces = other.getBlockFaces();
        return !(this$blockFaces == null ? other$blockFaces != null : !((Object)this$blockFaces).equals(other$blockFaces));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCharge();
        Set<Direction> $blockFaces = this.getBlockFaces();
        result = result * 59 + ($blockFaces == null ? 43 : ((Object)$blockFaces).hashCode());
        return result;
    }

    public String toString() {
        return "SculkBlockChargeEventData(charge=" + this.getCharge() + ", blockFaces=" + this.getBlockFaces() + ")";
    }
}

