/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.advancement;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import java.util.List;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class Advancement {
    @NonNull
    private final String id;
    @NonNull
    private final List<List<String>> requirements;
    private final String parentId;
    private final DisplayData displayData;
    private final boolean sendsTelemetryEvent;

    public Advancement(@NonNull String id, @NonNull List<List<String>> requirements, boolean sendsTelemetryEvent) {
        this(id, requirements, null, null, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    public Advancement(@NonNull String id, @NonNull List<List<String>> requirements, String parentId, boolean sendsTelemetryEvent) {
        this(id, requirements, parentId, null, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    public Advancement(@NonNull String id, @NonNull List<List<String>> requirements, DisplayData displayData, boolean sendsTelemetryEvent) {
        this(id, requirements, null, displayData, sendsTelemetryEvent);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public List<List<String>> getRequirements() {
        return this.requirements;
    }

    public String getParentId() {
        return this.parentId;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public boolean isSendsTelemetryEvent() {
        return this.sendsTelemetryEvent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Advancement)) {
            return false;
        }
        Advancement other = (Advancement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSendsTelemetryEvent() != other.isSendsTelemetryEvent()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<List<String>> this$requirements = this.getRequirements();
        List<List<String>> other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        DisplayData this$displayData = this.getDisplayData();
        DisplayData other$displayData = other.getDisplayData();
        return !(this$displayData == null ? other$displayData != null : !((Object)this$displayData).equals(other$displayData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Advancement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSendsTelemetryEvent() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<List<String>> $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        DisplayData $displayData = this.getDisplayData();
        result = result * 59 + ($displayData == null ? 43 : ((Object)$displayData).hashCode());
        return result;
    }

    public String toString() {
        return "Advancement(id=" + this.getId() + ", requirements=" + this.getRequirements() + ", parentId=" + this.getParentId() + ", displayData=" + this.getDisplayData() + ", sendsTelemetryEvent=" + this.isSendsTelemetryEvent() + ")";
    }

    public Advancement(@NonNull String id, @NonNull List<List<String>> requirements, String parentId, DisplayData displayData, boolean sendsTelemetryEvent) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (requirements == null) {
            throw new NullPointerException("requirements is marked non-null but is null");
        }
        this.id = id;
        this.requirements = requirements;
        this.parentId = parentId;
        this.displayData = displayData;
        this.sendsTelemetryEvent = sendsTelemetryEvent;
    }

    public static class DisplayData {
        @NonNull
        private final Component title;
        @NonNull
        private final Component description;
        @Nullable
        private final ItemStack icon;
        @NonNull
        private final AdvancementType advancementType;
        private final boolean showToast;
        private final boolean hidden;
        private final float posX;
        private final float posY;
        @Nullable
        private final String backgroundTexture;

        public DisplayData(@NonNull Component title, @NonNull Component description, @Nullable ItemStack icon, @NonNull AdvancementType advancementType, boolean showToast, boolean hidden, float posX, float posY) {
            this(title, description, icon, advancementType, showToast, hidden, posX, posY, null);
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (advancementType == null) {
                throw new NullPointerException("advancementType is marked non-null but is null");
            }
        }

        @NonNull
        public Component getTitle() {
            return this.title;
        }

        @NonNull
        public Component getDescription() {
            return this.description;
        }

        @Nullable
        public ItemStack getIcon() {
            return this.icon;
        }

        @NonNull
        public AdvancementType getAdvancementType() {
            return this.advancementType;
        }

        public boolean isShowToast() {
            return this.showToast;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        @Nullable
        public String getBackgroundTexture() {
            return this.backgroundTexture;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DisplayData)) {
                return false;
            }
            DisplayData other = (DisplayData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isShowToast() != other.isShowToast()) {
                return false;
            }
            if (this.isHidden() != other.isHidden()) {
                return false;
            }
            if (Float.compare(this.getPosX(), other.getPosX()) != 0) {
                return false;
            }
            if (Float.compare(this.getPosY(), other.getPosY()) != 0) {
                return false;
            }
            Component this$title = this.getTitle();
            Component other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Component this$description = this.getDescription();
            Component other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            ItemStack this$icon = this.getIcon();
            ItemStack other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !((Object)this$icon).equals(other$icon)) {
                return false;
            }
            AdvancementType this$advancementType = this.getAdvancementType();
            AdvancementType other$advancementType = other.getAdvancementType();
            if (this$advancementType == null ? other$advancementType != null : !((Object)((Object)this$advancementType)).equals((Object)other$advancementType)) {
                return false;
            }
            String this$backgroundTexture = this.getBackgroundTexture();
            String other$backgroundTexture = other.getBackgroundTexture();
            return !(this$backgroundTexture == null ? other$backgroundTexture != null : !this$backgroundTexture.equals(other$backgroundTexture));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DisplayData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isShowToast() ? 79 : 97);
            result = result * 59 + (this.isHidden() ? 79 : 97);
            result = result * 59 + Float.floatToIntBits(this.getPosX());
            result = result * 59 + Float.floatToIntBits(this.getPosY());
            Component $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Component $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            ItemStack $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : ((Object)$icon).hashCode());
            AdvancementType $advancementType = this.getAdvancementType();
            result = result * 59 + ($advancementType == null ? 43 : ((Object)((Object)$advancementType)).hashCode());
            String $backgroundTexture = this.getBackgroundTexture();
            result = result * 59 + ($backgroundTexture == null ? 43 : $backgroundTexture.hashCode());
            return result;
        }

        public String toString() {
            return "Advancement.DisplayData(title=" + this.getTitle() + ", description=" + this.getDescription() + ", icon=" + this.getIcon() + ", advancementType=" + this.getAdvancementType() + ", showToast=" + this.isShowToast() + ", hidden=" + this.isHidden() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", backgroundTexture=" + this.getBackgroundTexture() + ")";
        }

        public DisplayData(@NonNull Component title, @NonNull Component description, @Nullable ItemStack icon, @NonNull AdvancementType advancementType, boolean showToast, boolean hidden, float posX, float posY, @Nullable String backgroundTexture) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (advancementType == null) {
                throw new NullPointerException("advancementType is marked non-null but is null");
            }
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.advancementType = advancementType;
            this.showToast = showToast;
            this.hidden = hidden;
            this.posX = posX;
            this.posY = posY;
            this.backgroundTexture = backgroundTexture;
        }

        public static enum AdvancementType {
            TASK,
            CHALLENGE,
            GOAL;

            private static final AdvancementType[] VALUES;

            public static AdvancementType from(int id) {
                return VALUES[id];
            }

            static {
                VALUES = AdvancementType.values();
            }
        }
    }
}

