/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.serverbound;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class ServerboundKeyPacket
implements Packet {
    @NonNull
    private final byte[] sharedKey;
    @NonNull
    private final byte[] verifyToken;

    public ServerboundKeyPacket(PublicKey publicKey, SecretKey secretKey, byte[] verifyToken) {
        this.sharedKey = ServerboundKeyPacket.runEncryption(1, publicKey, secretKey.getEncoded());
        this.verifyToken = ServerboundKeyPacket.runEncryption(1, publicKey, verifyToken);
    }

    public SecretKey getSecretKey(PrivateKey privateKey) {
        return new SecretKeySpec(ServerboundKeyPacket.runEncryption(2, privateKey, this.sharedKey), "AES");
    }

    public byte[] getVerifyToken(PrivateKey privateKey) {
        return ServerboundKeyPacket.runEncryption(2, privateKey, this.verifyToken);
    }

    public ServerboundKeyPacket(NetInput in) throws IOException {
        this.sharedKey = in.readBytes(in.readVarInt());
        this.verifyToken = in.readBytes(in.readVarInt());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.sharedKey.length);
        out.writeBytes(this.sharedKey);
        out.writeVarInt(this.verifyToken.length);
        out.writeBytes(this.verifyToken);
    }

    public boolean isPriority() {
        return true;
    }

    private static byte[] runEncryption(int mode, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(key.getAlgorithm().equals("RSA") ? "RSA/ECB/PKCS1Padding" : "AES/CFB8/NoPadding");
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Failed to " + (mode == 2 ? "decrypt" : "encrypt") + " data.", e);
        }
    }

    public String toString() {
        return "ServerboundKeyPacket(sharedKey=" + Arrays.toString(this.sharedKey) + ", verifyToken=" + Arrays.toString(this.verifyToken) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundKeyPacket)) {
            return false;
        }
        ServerboundKeyPacket other = (ServerboundKeyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.sharedKey, other.sharedKey)) {
            return false;
        }
        return Arrays.equals(this.verifyToken, other.verifyToken);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundKeyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.sharedKey);
        result = result * 59 + Arrays.hashCode(this.verifyToken);
        return result;
    }
}

