/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.login.clientbound;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundGameProfilePacket
implements Packet {
    @NonNull
    private final GameProfile profile;

    public ClientboundGameProfilePacket(NetInput in) throws IOException {
        this.profile = new GameProfile(in.readUUID(), in.readString());
    }

    public void write(NetOutput out) throws IOException {
        out.writeUUID(this.profile.getId());
        out.writeString(this.profile.getName());
    }

    public boolean isPriority() {
        return true;
    }

    @NonNull
    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundGameProfilePacket)) {
            return false;
        }
        ClientboundGameProfilePacket other = (ClientboundGameProfilePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        return !(this$profile == null ? other$profile != null : !this$profile.equals(other$profile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundGameProfilePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundGameProfilePacket(profile=" + this.getProfile() + ")";
    }

    public ClientboundGameProfilePacket withProfile(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.profile == profile ? this : new ClientboundGameProfilePacket(profile);
    }

    public ClientboundGameProfilePacket(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.profile = profile;
    }
}

