/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerState;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundPlayerCommandPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final PlayerState state;
    private final int jumpBoost;

    public ServerboundPlayerCommandPacket(int entityId, PlayerState state) {
        this(entityId, state, 0);
    }

    public ServerboundPlayerCommandPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.state = MagicValues.key(PlayerState.class, in.readVarInt());
        this.jumpBoost = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.state).intValue());
        out.writeVarInt(this.jumpBoost);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public PlayerState getState() {
        return this.state;
    }

    public int getJumpBoost() {
        return this.jumpBoost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerCommandPacket)) {
            return false;
        }
        ServerboundPlayerCommandPacket other = (ServerboundPlayerCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getJumpBoost() != other.getJumpBoost()) {
            return false;
        }
        PlayerState this$state = this.getState();
        PlayerState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlayerCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getJumpBoost();
        PlayerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundPlayerCommandPacket(entityId=" + this.getEntityId() + ", state=" + (Object)((Object)this.getState()) + ", jumpBoost=" + this.getJumpBoost() + ")";
    }

    public ServerboundPlayerCommandPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundPlayerCommandPacket(entityId, this.state, this.jumpBoost);
    }

    public ServerboundPlayerCommandPacket withState(@NonNull PlayerState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return this.state == state ? this : new ServerboundPlayerCommandPacket(this.entityId, state, this.jumpBoost);
    }

    public ServerboundPlayerCommandPacket withJumpBoost(int jumpBoost) {
        return this.jumpBoost == jumpBoost ? this : new ServerboundPlayerCommandPacket(this.entityId, this.state, jumpBoost);
    }

    public ServerboundPlayerCommandPacket(int entityId, @NonNull PlayerState state, int jumpBoost) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.entityId = entityId;
        this.state = state;
        this.jumpBoost = jumpBoost;
    }
}

