/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.player.PlayerAction;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundPlayerActionPacket
implements Packet {
    @NonNull
    private final PlayerAction action;
    @NonNull
    private final Position position;
    @NonNull
    private final Direction face;

    public ServerboundPlayerActionPacket(NetInput in) throws IOException {
        this.action = MagicValues.key(PlayerAction.class, in.readVarInt());
        this.position = Position.read(in);
        this.face = Direction.VALUES[in.readUnsignedByte()];
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        Position.write(out, this.position);
        out.writeByte(this.face.ordinal());
    }

    @NonNull
    public PlayerAction getAction() {
        return this.action;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public Direction getFace() {
        return this.face;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerActionPacket)) {
            return false;
        }
        ServerboundPlayerActionPacket other = (ServerboundPlayerActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerAction this$action = this.getAction();
        PlayerAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Direction this$face = this.getFace();
        Direction other$face = other.getFace();
        return !(this$face == null ? other$face != null : !this$face.equals(other$face));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundPlayerActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Direction $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : $face.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundPlayerActionPacket(action=" + (Object)((Object)this.getAction()) + ", position=" + this.getPosition() + ", face=" + this.getFace() + ")";
    }

    public ServerboundPlayerActionPacket withAction(@NonNull PlayerAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ServerboundPlayerActionPacket(action, this.position, this.face);
    }

    public ServerboundPlayerActionPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ServerboundPlayerActionPacket(this.action, position, this.face);
    }

    public ServerboundPlayerActionPacket withFace(@NonNull Direction face) {
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        return this.face == face ? this : new ServerboundPlayerActionPacket(this.action, this.position, face);
    }

    public ServerboundPlayerActionPacket(@NonNull PlayerAction action, @NonNull Position position, @NonNull Direction face) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (face == null) {
            throw new NullPointerException("face is marked non-null but is null");
        }
        this.action = action;
        this.position = position;
        this.face = face;
    }
}

