/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.player;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ServerboundMovePlayerRotPacket
implements Packet {
    private final boolean onGround;
    private final float yaw;
    private final float pitch;

    public ServerboundMovePlayerRotPacket(NetInput in) throws IOException {
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        this.onGround = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        out.writeBoolean(this.onGround);
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerRotPacket)) {
            return false;
        }
        ServerboundMovePlayerRotPacket other = (ServerboundMovePlayerRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundMovePlayerRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public String toString() {
        return "ServerboundMovePlayerRotPacket(onGround=" + this.isOnGround() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public ServerboundMovePlayerRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerRotPacket(onGround, this.yaw, this.pitch);
    }

    public ServerboundMovePlayerRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMovePlayerRotPacket(this.onGround, yaw, this.pitch);
    }

    public ServerboundMovePlayerRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMovePlayerRotPacket(this.onGround, this.yaw, pitch);
    }

    public ServerboundMovePlayerRotPacket(boolean onGround, float yaw, float pitch) {
        this.onGround = onGround;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

