/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.inventory.CraftingBookStateType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundRecipeBookChangeSettingsPacket
implements Packet {
    @NonNull
    private final CraftingBookStateType type;
    private final boolean bookOpen;
    private final boolean filterActive;

    public ServerboundRecipeBookChangeSettingsPacket(NetInput in) throws IOException {
        this.type = MagicValues.key(CraftingBookStateType.class, in.readVarInt());
        this.bookOpen = in.readBoolean();
        this.filterActive = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeBoolean(this.bookOpen);
        out.writeBoolean(this.filterActive);
    }

    @NonNull
    public CraftingBookStateType getType() {
        return this.type;
    }

    public boolean isBookOpen() {
        return this.bookOpen;
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundRecipeBookChangeSettingsPacket)) {
            return false;
        }
        ServerboundRecipeBookChangeSettingsPacket other = (ServerboundRecipeBookChangeSettingsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBookOpen() != other.isBookOpen()) {
            return false;
        }
        if (this.isFilterActive() != other.isFilterActive()) {
            return false;
        }
        CraftingBookStateType this$type = this.getType();
        CraftingBookStateType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundRecipeBookChangeSettingsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBookOpen() ? 79 : 97);
        result = result * 59 + (this.isFilterActive() ? 79 : 97);
        CraftingBookStateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundRecipeBookChangeSettingsPacket(type=" + (Object)((Object)this.getType()) + ", bookOpen=" + this.isBookOpen() + ", filterActive=" + this.isFilterActive() + ")";
    }

    public ServerboundRecipeBookChangeSettingsPacket withType(@NonNull CraftingBookStateType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerboundRecipeBookChangeSettingsPacket(type, this.bookOpen, this.filterActive);
    }

    public ServerboundRecipeBookChangeSettingsPacket withBookOpen(boolean bookOpen) {
        return this.bookOpen == bookOpen ? this : new ServerboundRecipeBookChangeSettingsPacket(this.type, bookOpen, this.filterActive);
    }

    public ServerboundRecipeBookChangeSettingsPacket withFilterActive(boolean filterActive) {
        return this.filterActive == filterActive ? this : new ServerboundRecipeBookChangeSettingsPacket(this.type, this.bookOpen, filterActive);
    }

    public ServerboundRecipeBookChangeSettingsPacket(@NonNull CraftingBookStateType type, boolean bookOpen, boolean filterActive) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.bookOpen = bookOpen;
        this.filterActive = filterActive;
    }
}

