/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ServerboundEditBookPacket
implements Packet {
    private final int slot;
    private final List<String> pages;
    @Nullable
    private final String title;

    public ServerboundEditBookPacket(NetInput in) throws IOException {
        this.slot = in.readVarInt();
        this.pages = new ArrayList<String>();
        int pagesSize = in.readVarInt();
        for (int i = 0; i < pagesSize; ++i) {
            this.pages.add(in.readString());
        }
        this.title = in.readBoolean() ? in.readString() : null;
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.slot);
        out.writeVarInt(this.pages.size());
        for (String page : this.pages) {
            out.writeString(page);
        }
        out.writeBoolean(this.title != null);
        if (this.title != null) {
            out.writeString(this.title);
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public List<String> getPages() {
        return this.pages;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundEditBookPacket)) {
            return false;
        }
        ServerboundEditBookPacket other = (ServerboundEditBookPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        List<String> this$pages = this.getPages();
        List<String> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundEditBookPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        List<String> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundEditBookPacket(slot=" + this.getSlot() + ", pages=" + this.getPages() + ", title=" + this.getTitle() + ")";
    }

    public ServerboundEditBookPacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundEditBookPacket(slot, this.pages, this.title);
    }

    public ServerboundEditBookPacket withPages(List<String> pages) {
        return this.pages == pages ? this : new ServerboundEditBookPacket(this.slot, pages, this.title);
    }

    public ServerboundEditBookPacket withTitle(@Nullable String title) {
        return this.title == title ? this : new ServerboundEditBookPacket(this.slot, this.pages, title);
    }

    public ServerboundEditBookPacket(int slot, List<String> pages, @Nullable String title) {
        this.slot = slot;
        this.pages = pages;
        this.title = title;
    }
}

