/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ServerboundCommandSuggestionPacket
implements Packet {
    private final int transactionId;
    @NonNull
    private final String text;

    public ServerboundCommandSuggestionPacket(NetInput in) throws IOException {
        this.transactionId = in.readVarInt();
        this.text = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.transactionId);
        out.writeString(this.text);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCommandSuggestionPacket)) {
            return false;
        }
        ServerboundCommandSuggestionPacket other = (ServerboundCommandSuggestionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundCommandSuggestionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundCommandSuggestionPacket(transactionId=" + this.getTransactionId() + ", text=" + this.getText() + ")";
    }

    public ServerboundCommandSuggestionPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundCommandSuggestionPacket(transactionId, this.text);
    }

    public ServerboundCommandSuggestionPacket withText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.text == text ? this : new ServerboundCommandSuggestionPacket(this.transactionId, text);
    }

    public ServerboundCommandSuggestionPacket(int transactionId, @NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.text = text;
    }
}

