/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.serverbound;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.player.HandPreference;
import com.github.steveice10.mc.protocol.data.game.setting.ChatVisibility;
import com.github.steveice10.mc.protocol.data.game.setting.SkinPart;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ServerboundClientInformationPacket
implements Packet {
    @NonNull
    private final String locale;
    private final int renderDistance;
    @NonNull
    private final ChatVisibility chatVisibility;
    private final boolean useChatColors;
    @NonNull
    private final List<SkinPart> visibleParts;
    @NonNull
    private final HandPreference mainHand;
    private final boolean textFilteringEnabled;
    private final boolean allowsListing;

    public ServerboundClientInformationPacket(NetInput in) throws IOException {
        this.locale = in.readString();
        this.renderDistance = in.readByte();
        this.chatVisibility = MagicValues.key(ChatVisibility.class, in.readVarInt());
        this.useChatColors = in.readBoolean();
        this.visibleParts = new ArrayList<SkinPart>();
        int flags = in.readUnsignedByte();
        for (SkinPart part : SkinPart.VALUES) {
            int bit = 1 << part.ordinal();
            if ((flags & bit) != bit) continue;
            this.visibleParts.add(part);
        }
        this.mainHand = MagicValues.key(HandPreference.class, in.readVarInt());
        this.textFilteringEnabled = in.readBoolean();
        this.allowsListing = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeString(this.locale);
        out.writeByte(this.renderDistance);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.chatVisibility).intValue());
        out.writeBoolean(this.useChatColors);
        int flags = 0;
        for (SkinPart part : this.visibleParts) {
            flags |= 1 << part.ordinal();
        }
        out.writeByte(flags);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.mainHand).intValue());
        out.writeBoolean(this.textFilteringEnabled);
        out.writeBoolean(this.allowsListing);
    }

    @NonNull
    public String getLocale() {
        return this.locale;
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    @NonNull
    public ChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public boolean isUseChatColors() {
        return this.useChatColors;
    }

    @NonNull
    public List<SkinPart> getVisibleParts() {
        return this.visibleParts;
    }

    @NonNull
    public HandPreference getMainHand() {
        return this.mainHand;
    }

    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean isAllowsListing() {
        return this.allowsListing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundClientInformationPacket)) {
            return false;
        }
        ServerboundClientInformationPacket other = (ServerboundClientInformationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRenderDistance() != other.getRenderDistance()) {
            return false;
        }
        if (this.isUseChatColors() != other.isUseChatColors()) {
            return false;
        }
        if (this.isTextFilteringEnabled() != other.isTextFilteringEnabled()) {
            return false;
        }
        if (this.isAllowsListing() != other.isAllowsListing()) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        ChatVisibility this$chatVisibility = this.getChatVisibility();
        ChatVisibility other$chatVisibility = other.getChatVisibility();
        if (this$chatVisibility == null ? other$chatVisibility != null : !((Object)((Object)this$chatVisibility)).equals((Object)other$chatVisibility)) {
            return false;
        }
        List<SkinPart> this$visibleParts = this.getVisibleParts();
        List<SkinPart> other$visibleParts = other.getVisibleParts();
        if (this$visibleParts == null ? other$visibleParts != null : !((Object)this$visibleParts).equals(other$visibleParts)) {
            return false;
        }
        HandPreference this$mainHand = this.getMainHand();
        HandPreference other$mainHand = other.getMainHand();
        return !(this$mainHand == null ? other$mainHand != null : !((Object)((Object)this$mainHand)).equals((Object)other$mainHand));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerboundClientInformationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRenderDistance();
        result = result * 59 + (this.isUseChatColors() ? 79 : 97);
        result = result * 59 + (this.isTextFilteringEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllowsListing() ? 79 : 97);
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        ChatVisibility $chatVisibility = this.getChatVisibility();
        result = result * 59 + ($chatVisibility == null ? 43 : ((Object)((Object)$chatVisibility)).hashCode());
        List<SkinPart> $visibleParts = this.getVisibleParts();
        result = result * 59 + ($visibleParts == null ? 43 : ((Object)$visibleParts).hashCode());
        HandPreference $mainHand = this.getMainHand();
        result = result * 59 + ($mainHand == null ? 43 : ((Object)((Object)$mainHand)).hashCode());
        return result;
    }

    public String toString() {
        return "ServerboundClientInformationPacket(locale=" + this.getLocale() + ", renderDistance=" + this.getRenderDistance() + ", chatVisibility=" + (Object)((Object)this.getChatVisibility()) + ", useChatColors=" + this.isUseChatColors() + ", visibleParts=" + this.getVisibleParts() + ", mainHand=" + (Object)((Object)this.getMainHand()) + ", textFilteringEnabled=" + this.isTextFilteringEnabled() + ", allowsListing=" + this.isAllowsListing() + ")";
    }

    public ServerboundClientInformationPacket withLocale(@NonNull String locale) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        return this.locale == locale ? this : new ServerboundClientInformationPacket(locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withRenderDistance(int renderDistance) {
        return this.renderDistance == renderDistance ? this : new ServerboundClientInformationPacket(this.locale, renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withChatVisibility(@NonNull ChatVisibility chatVisibility) {
        if (chatVisibility == null) {
            throw new NullPointerException("chatVisibility is marked non-null but is null");
        }
        return this.chatVisibility == chatVisibility ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withUseChatColors(boolean useChatColors) {
        return this.useChatColors == useChatColors ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withVisibleParts(@NonNull List<SkinPart> visibleParts) {
        if (visibleParts == null) {
            throw new NullPointerException("visibleParts is marked non-null but is null");
        }
        return this.visibleParts == visibleParts ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, visibleParts, this.mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withMainHand(@NonNull HandPreference mainHand) {
        if (mainHand == null) {
            throw new NullPointerException("mainHand is marked non-null but is null");
        }
        return this.mainHand == mainHand ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, mainHand, this.textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withTextFilteringEnabled(boolean textFilteringEnabled) {
        return this.textFilteringEnabled == textFilteringEnabled ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, textFilteringEnabled, this.allowsListing);
    }

    public ServerboundClientInformationPacket withAllowsListing(boolean allowsListing) {
        return this.allowsListing == allowsListing ? this : new ServerboundClientInformationPacket(this.locale, this.renderDistance, this.chatVisibility, this.useChatColors, this.visibleParts, this.mainHand, this.textFilteringEnabled, allowsListing);
    }

    public ServerboundClientInformationPacket(@NonNull String locale, int renderDistance, @NonNull ChatVisibility chatVisibility, boolean useChatColors, @NonNull List<SkinPart> visibleParts, @NonNull HandPreference mainHand, boolean textFilteringEnabled, boolean allowsListing) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (chatVisibility == null) {
            throw new NullPointerException("chatVisibility is marked non-null but is null");
        }
        if (visibleParts == null) {
            throw new NullPointerException("visibleParts is marked non-null but is null");
        }
        if (mainHand == null) {
            throw new NullPointerException("mainHand is marked non-null but is null");
        }
        this.locale = locale;
        this.renderDistance = renderDistance;
        this.chatVisibility = chatVisibility;
        this.useChatColors = useChatColors;
        this.visibleParts = visibleParts;
        this.mainHand = mainHand;
        this.textFilteringEnabled = textFilteringEnabled;
        this.allowsListing = allowsListing;
    }
}

