/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundSetDefaultSpawnPositionPacket
implements Packet {
    @NonNull
    private final Position position;
    private final float angle;

    public ClientboundSetDefaultSpawnPositionPacket(NetInput in) throws IOException {
        this.position = Position.read(in);
        this.angle = in.readFloat();
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.position);
        out.writeFloat(this.angle);
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDefaultSpawnPositionPacket)) {
            return false;
        }
        ClientboundSetDefaultSpawnPositionPacket other = (ClientboundSetDefaultSpawnPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getAngle(), other.getAngle()) != 0) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetDefaultSpawnPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getAngle());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundSetDefaultSpawnPositionPacket(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
    }

    public ClientboundSetDefaultSpawnPositionPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundSetDefaultSpawnPositionPacket(position, this.angle);
    }

    public ClientboundSetDefaultSpawnPositionPacket withAngle(float angle) {
        return this.angle == angle ? this : new ClientboundSetDefaultSpawnPositionPacket(this.position, angle);
    }

    public ClientboundSetDefaultSpawnPositionPacket(@NonNull Position position, float angle) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.position = position;
        this.angle = angle;
    }
}

