/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.level.block.BlockChangeEntry;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundSectionBlocksUpdatePacket
implements Packet {
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final boolean ignoreOldLight;
    @NonNull
    private final BlockChangeEntry[] entries;

    public ClientboundSectionBlocksUpdatePacket(int chunkX, int chunkY, int chunkZ, boolean ignoreOldLight, BlockChangeEntry ... entries) {
        if (entries == null || entries.length == 0) {
            throw new IllegalArgumentException("Entries must contain at least 1 value.");
        }
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.ignoreOldLight = ignoreOldLight;
        this.entries = entries;
    }

    public ClientboundSectionBlocksUpdatePacket(NetInput in) throws IOException {
        long chunkPosition = in.readLong();
        this.chunkX = (int)(chunkPosition >> 42);
        this.chunkY = (int)(chunkPosition << 44 >> 44);
        this.chunkZ = (int)(chunkPosition << 22 >> 42);
        this.ignoreOldLight = in.readBoolean();
        this.entries = new BlockChangeEntry[in.readVarInt()];
        for (int index = 0; index < this.entries.length; ++index) {
            long blockData = in.readVarLong();
            short position = (short)(blockData & 0xFFFL);
            int x = (this.chunkX << 4) + (position >>> 8 & 0xF);
            int y = (this.chunkY << 4) + (position & 0xF);
            int z = (this.chunkZ << 4) + (position >>> 4 & 0xF);
            this.entries[index] = new BlockChangeEntry(new Position(x, y, z), (int)(blockData >>> 12));
        }
    }

    public void write(NetOutput out) throws IOException {
        long chunkPosition = 0L;
        chunkPosition |= ((long)this.chunkX & 0x3FFFFFL) << 42;
        out.writeLong((chunkPosition |= ((long)this.chunkZ & 0x3FFFFFL) << 20) | (long)this.chunkY & 0xFFFFFL);
        out.writeBoolean(this.ignoreOldLight);
        out.writeVarInt(this.entries.length);
        for (BlockChangeEntry entry : this.entries) {
            short position = (short)(entry.getPosition().getX() - (this.chunkX << 4) << 8 | entry.getPosition().getZ() - (this.chunkZ << 4) << 4 | entry.getPosition().getY() - (this.chunkY << 4));
            out.writeVarLong((long)entry.getBlock() << 12 | (long)position);
        }
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public boolean isIgnoreOldLight() {
        return this.ignoreOldLight;
    }

    @NonNull
    public BlockChangeEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSectionBlocksUpdatePacket)) {
            return false;
        }
        ClientboundSectionBlocksUpdatePacket other = (ClientboundSectionBlocksUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkX() != other.getChunkX()) {
            return false;
        }
        if (this.getChunkY() != other.getChunkY()) {
            return false;
        }
        if (this.getChunkZ() != other.getChunkZ()) {
            return false;
        }
        if (this.isIgnoreOldLight() != other.isIgnoreOldLight()) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSectionBlocksUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkX();
        result = result * 59 + this.getChunkY();
        result = result * 59 + this.getChunkZ();
        result = result * 59 + (this.isIgnoreOldLight() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public String toString() {
        return "ClientboundSectionBlocksUpdatePacket(chunkX=" + this.getChunkX() + ", chunkY=" + this.getChunkY() + ", chunkZ=" + this.getChunkZ() + ", ignoreOldLight=" + this.isIgnoreOldLight() + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public ClientboundSectionBlocksUpdatePacket withChunkX(int chunkX) {
        return this.chunkX == chunkX ? this : new ClientboundSectionBlocksUpdatePacket(chunkX, this.chunkY, this.chunkZ, this.ignoreOldLight, this.entries);
    }

    public ClientboundSectionBlocksUpdatePacket withChunkY(int chunkY) {
        return this.chunkY == chunkY ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, chunkY, this.chunkZ, this.ignoreOldLight, this.entries);
    }

    public ClientboundSectionBlocksUpdatePacket withChunkZ(int chunkZ) {
        return this.chunkZ == chunkZ ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, this.chunkY, chunkZ, this.ignoreOldLight, this.entries);
    }

    public ClientboundSectionBlocksUpdatePacket withIgnoreOldLight(boolean ignoreOldLight) {
        return this.ignoreOldLight == ignoreOldLight ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, this.chunkY, this.chunkZ, ignoreOldLight, this.entries);
    }

    public ClientboundSectionBlocksUpdatePacket withEntries(@NonNull BlockChangeEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.entries == entries ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, this.chunkY, this.chunkZ, this.ignoreOldLight, entries);
    }
}

