/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.level.event.BonemealGrowEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakBlockEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.BreakPotionEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.ComposterEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.DragonFireballEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEvent;
import com.github.steveice10.mc.protocol.data.game.level.event.LevelEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.ParticleEvent;
import com.github.steveice10.mc.protocol.data.game.level.event.RecordEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SmokeEventData;
import com.github.steveice10.mc.protocol.data.game.level.event.SoundEvent;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundLevelEventPacket
implements Packet {
    @NonNull
    private final LevelEvent event;
    @NonNull
    private final Position position;
    private final LevelEventData data;
    private final boolean broadcast;

    public ClientboundLevelEventPacket(@NonNull LevelEvent event, @NonNull Position position, @NonNull LevelEventData data) {
        this(event, position, data, false);
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public ClientboundLevelEventPacket(NetInput in) throws IOException {
        this.event = MagicValues.key(LevelEvent.class, in.readInt());
        this.position = Position.read(in);
        int value = in.readInt();
        this.data = this.event == SoundEvent.RECORD ? new RecordEventData(value) : (this.event == ParticleEvent.SMOKE ? (LevelEventData)MagicValues.key(SmokeEventData.class, value % 6) : (this.event == ParticleEvent.BREAK_BLOCK ? new BreakBlockEventData(value) : (this.event == ParticleEvent.BREAK_SPLASH_POTION ? new BreakPotionEventData(value) : (this.event == ParticleEvent.BONEMEAL_GROW || this.event == ParticleEvent.BONEMEAL_GROW_WITH_SOUND ? new BonemealGrowEventData(value) : (this.event == ParticleEvent.COMPOSTER ? (value > 0 ? ComposterEventData.FILL_SUCCESS : ComposterEventData.FILL) : (this.event == ParticleEvent.ENDERDRAGON_FIREBALL_EXPLODE ? (value == 1 ? DragonFireballEventData.HAS_SOUND : DragonFireballEventData.NO_SOUND) : null))))));
        this.broadcast = in.readBoolean();
    }

    public void write(NetOutput out) throws IOException {
        out.writeInt(MagicValues.value(Integer.class, this.event).intValue());
        Position.write(out, this.position);
        int value = 0;
        if (this.data instanceof RecordEventData) {
            value = ((RecordEventData)this.data).getRecordId();
        } else if (this.data instanceof SmokeEventData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof BreakBlockEventData) {
            value = ((BreakBlockEventData)this.data).getBlockState();
        } else if (this.data instanceof BreakPotionEventData) {
            value = ((BreakPotionEventData)this.data).getPotionId();
        } else if (this.data instanceof BonemealGrowEventData) {
            value = ((BonemealGrowEventData)this.data).getParticleCount();
        } else if (this.data instanceof ComposterEventData) {
            value = MagicValues.value(Integer.class, this.data);
        } else if (this.data instanceof DragonFireballEventData) {
            value = MagicValues.value(Integer.class, this.data);
        }
        out.writeInt(value);
        out.writeBoolean(this.broadcast);
    }

    @NonNull
    public LevelEvent getEvent() {
        return this.event;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    public LevelEventData getData() {
        return this.data;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLevelEventPacket)) {
            return false;
        }
        ClientboundLevelEventPacket other = (ClientboundLevelEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBroadcast() != other.isBroadcast()) {
            return false;
        }
        LevelEvent this$event = this.getEvent();
        LevelEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        LevelEventData this$data = this.getData();
        LevelEventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundLevelEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBroadcast() ? 79 : 97);
        LevelEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        LevelEventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundLevelEventPacket(event=" + this.getEvent() + ", position=" + this.getPosition() + ", data=" + this.getData() + ", broadcast=" + this.isBroadcast() + ")";
    }

    public ClientboundLevelEventPacket withEvent(@NonNull LevelEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.event == event ? this : new ClientboundLevelEventPacket(event, this.position, this.data, this.broadcast);
    }

    public ClientboundLevelEventPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundLevelEventPacket(this.event, position, this.data, this.broadcast);
    }

    public ClientboundLevelEventPacket withData(LevelEventData data) {
        return this.data == data ? this : new ClientboundLevelEventPacket(this.event, this.position, data, this.broadcast);
    }

    public ClientboundLevelEventPacket withBroadcast(boolean broadcast) {
        return this.broadcast == broadcast ? this : new ClientboundLevelEventPacket(this.event, this.position, this.data, broadcast);
    }

    public ClientboundLevelEventPacket(@NonNull LevelEvent event, @NonNull Position position, LevelEventData data, boolean broadcast) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.event = event;
        this.position = position;
        this.data = data;
        this.broadcast = broadcast;
    }
}

