/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.level;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.level.vibration.BlockVibrationSource;
import com.github.steveice10.mc.protocol.data.game.level.vibration.EntityVibrationSource;
import com.github.steveice10.mc.protocol.data.game.level.vibration.VibrationSource;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundAddVibrationSignalPacket
implements Packet {
    @NonNull
    private final Position origin;
    @NonNull
    private final VibrationSource destination;
    private final int arrivalInTicks;

    public ClientboundAddVibrationSignalPacket(NetInput in) throws IOException {
        String identifier;
        this.origin = Position.read(in);
        switch (identifier = Identifier.formalize(in.readString())) {
            case "minecraft:block": {
                this.destination = BlockVibrationSource.read(in);
                break;
            }
            case "minecraft:entity": {
                this.destination = EntityVibrationSource.read(in);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.arrivalInTicks = in.readVarInt();
    }

    public void write(NetOutput out) throws IOException {
        Position.write(out, this.origin);
        if (this.destination instanceof BlockVibrationSource) {
            out.writeString("minecraft:block");
            BlockVibrationSource.write(out, (BlockVibrationSource)this.destination);
        } else if (this.destination instanceof EntityVibrationSource) {
            out.writeString("minecraft:entity");
            EntityVibrationSource.write(out, (EntityVibrationSource)this.destination);
        }
        out.writeVarInt(this.arrivalInTicks);
    }

    @NonNull
    public Position getOrigin() {
        return this.origin;
    }

    @NonNull
    public VibrationSource getDestination() {
        return this.destination;
    }

    public int getArrivalInTicks() {
        return this.arrivalInTicks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddVibrationSignalPacket)) {
            return false;
        }
        ClientboundAddVibrationSignalPacket other = (ClientboundAddVibrationSignalPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getArrivalInTicks() != other.getArrivalInTicks()) {
            return false;
        }
        Position this$origin = this.getOrigin();
        Position other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)this$origin).equals(other$origin)) {
            return false;
        }
        VibrationSource this$destination = this.getDestination();
        VibrationSource other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddVibrationSignalPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArrivalInTicks();
        Position $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)$origin).hashCode());
        VibrationSource $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAddVibrationSignalPacket(origin=" + this.getOrigin() + ", destination=" + this.getDestination() + ", arrivalInTicks=" + this.getArrivalInTicks() + ")";
    }

    public ClientboundAddVibrationSignalPacket withOrigin(@NonNull Position origin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        return this.origin == origin ? this : new ClientboundAddVibrationSignalPacket(origin, this.destination, this.arrivalInTicks);
    }

    public ClientboundAddVibrationSignalPacket withDestination(@NonNull VibrationSource destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return this.destination == destination ? this : new ClientboundAddVibrationSignalPacket(this.origin, destination, this.arrivalInTicks);
    }

    public ClientboundAddVibrationSignalPacket withArrivalInTicks(int arrivalInTicks) {
        return this.arrivalInTicks == arrivalInTicks ? this : new ClientboundAddVibrationSignalPacket(this.origin, this.destination, arrivalInTicks);
    }

    public ClientboundAddVibrationSignalPacket(@NonNull Position origin, @NonNull VibrationSource destination, int arrivalInTicks) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.origin = origin;
        this.destination = destination;
        this.arrivalInTicks = arrivalInTicks;
    }
}

