/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundOpenScreenPacket
implements Packet {
    private final int containerId;
    @NonNull
    private final ContainerType type;
    @NonNull
    private final String name;

    public ClientboundOpenScreenPacket(NetInput in) throws IOException {
        this.containerId = in.readVarInt();
        this.type = MagicValues.key(ContainerType.class, in.readVarInt());
        this.name = in.readString();
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.containerId);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.type).intValue());
        out.writeString(this.name);
    }

    public int getContainerId() {
        return this.containerId;
    }

    @NonNull
    public ContainerType getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundOpenScreenPacket)) {
            return false;
        }
        ClientboundOpenScreenPacket other = (ClientboundOpenScreenPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        ContainerType this$type = this.getType();
        ContainerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundOpenScreenPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        ContainerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundOpenScreenPacket(containerId=" + this.getContainerId() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ")";
    }

    public ClientboundOpenScreenPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundOpenScreenPacket(containerId, this.type, this.name);
    }

    public ClientboundOpenScreenPacket withType(@NonNull ContainerType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundOpenScreenPacket(this.containerId, type, this.name);
    }

    public ClientboundOpenScreenPacket withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundOpenScreenPacket(this.containerId, this.type, name);
    }

    public ClientboundOpenScreenPacket(int containerId, @NonNull ContainerType type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.containerId = containerId;
        this.type = type;
        this.name = name;
    }
}

