/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.inventory.property.ContainerProperty;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;

public class ClientboundContainerSetDataPacket
implements Packet {
    private final int containerId;
    private final int rawProperty;
    private final int value;

    public ClientboundContainerSetDataPacket(int containerId, ContainerProperty rawProperty, int value) {
        this(containerId, MagicValues.value(Integer.class, rawProperty), value);
    }

    public <T extends ContainerProperty> T getProperty(Class<T> type) {
        return (T)((ContainerProperty)MagicValues.key(type, this.value));
    }

    public ClientboundContainerSetDataPacket(NetInput in) throws IOException {
        this.containerId = in.readUnsignedByte();
        this.rawProperty = in.readShort();
        this.value = in.readShort();
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.containerId);
        out.writeShort(this.rawProperty);
        out.writeShort(this.value);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getRawProperty() {
        return this.rawProperty;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetDataPacket)) {
            return false;
        }
        ClientboundContainerSetDataPacket other = (ClientboundContainerSetDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getRawProperty() != other.getRawProperty()) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundContainerSetDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getRawProperty();
        result = result * 59 + this.getValue();
        return result;
    }

    public String toString() {
        return "ClientboundContainerSetDataPacket(containerId=" + this.getContainerId() + ", rawProperty=" + this.getRawProperty() + ", value=" + this.getValue() + ")";
    }

    public ClientboundContainerSetDataPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetDataPacket(containerId, this.rawProperty, this.value);
    }

    public ClientboundContainerSetDataPacket withRawProperty(int rawProperty) {
        return this.rawProperty == rawProperty ? this : new ClientboundContainerSetDataPacket(this.containerId, rawProperty, this.value);
    }

    public ClientboundContainerSetDataPacket withValue(int value) {
        return this.value == value ? this : new ClientboundContainerSetDataPacket(this.containerId, this.rawProperty, value);
    }

    public ClientboundContainerSetDataPacket(int containerId, int rawProperty, int value) {
        this.containerId = containerId;
        this.rawProperty = rawProperty;
        this.value = value;
    }
}

