/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundContainerSetContentPacket
implements Packet {
    private final int containerId;
    private final int stateId;
    @NonNull
    private final ItemStack[] items;
    private final ItemStack carriedItem;

    public ClientboundContainerSetContentPacket(NetInput in) throws IOException {
        this.containerId = in.readUnsignedByte();
        this.stateId = in.readVarInt();
        this.items = new ItemStack[in.readVarInt()];
        for (int index = 0; index < this.items.length; ++index) {
            this.items[index] = ItemStack.read(in);
        }
        this.carriedItem = ItemStack.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeByte(this.containerId);
        out.writeVarInt(this.stateId);
        out.writeVarInt(this.items.length);
        for (ItemStack item : this.items) {
            ItemStack.write(out, item);
        }
        ItemStack.write(out, this.carriedItem);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getStateId() {
        return this.stateId;
    }

    @NonNull
    public ItemStack[] getItems() {
        return this.items;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerSetContentPacket)) {
            return false;
        }
        ClientboundContainerSetContentPacket other = (ClientboundContainerSetContentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getStateId() != other.getStateId()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        ItemStack this$carriedItem = this.getCarriedItem();
        ItemStack other$carriedItem = other.getCarriedItem();
        return !(this$carriedItem == null ? other$carriedItem != null : !((Object)this$carriedItem).equals(other$carriedItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundContainerSetContentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getStateId();
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        ItemStack $carriedItem = this.getCarriedItem();
        result = result * 59 + ($carriedItem == null ? 43 : ((Object)$carriedItem).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundContainerSetContentPacket(containerId=" + this.getContainerId() + ", stateId=" + this.getStateId() + ", items=" + Arrays.deepToString(this.getItems()) + ", carriedItem=" + this.getCarriedItem() + ")";
    }

    public ClientboundContainerSetContentPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerSetContentPacket(containerId, this.stateId, this.items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withStateId(int stateId) {
        return this.stateId == stateId ? this : new ClientboundContainerSetContentPacket(this.containerId, stateId, this.items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withItems(@NonNull ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return this.items == items ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, items, this.carriedItem);
    }

    public ClientboundContainerSetContentPacket withCarriedItem(ItemStack carriedItem) {
        return this.carriedItem == carriedItem ? this : new ClientboundContainerSetContentPacket(this.containerId, this.stateId, this.items, carriedItem);
    }

    public ClientboundContainerSetContentPacket(int containerId, int stateId, @NonNull ItemStack[] items, ItemStack carriedItem) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.containerId = containerId;
        this.stateId = stateId;
        this.items = items;
        this.carriedItem = carriedItem;
    }
}

