/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.spawn;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.Position;
import com.github.steveice10.mc.protocol.data.game.entity.object.Direction;
import com.github.steveice10.mc.protocol.data.game.entity.type.PaintingType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class ClientboundAddPaintingPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final UUID uuid;
    @NonNull
    private final PaintingType paintingType;
    @NonNull
    private final Position position;
    @NonNull
    private final Direction direction;

    public ClientboundAddPaintingPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.uuid = in.readUUID();
        this.paintingType = MagicValues.key(PaintingType.class, in.readVarInt());
        this.position = Position.read(in);
        this.direction = Direction.getByHorizontalIndex(in.readUnsignedByte());
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        out.writeUUID(this.uuid);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.paintingType).intValue());
        Position.write(out, this.position);
        out.writeByte(this.direction.getHorizontalIndex());
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public PaintingType getPaintingType() {
        return this.paintingType;
    }

    @NonNull
    public Position getPosition() {
        return this.position;
    }

    @NonNull
    public Direction getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddPaintingPacket)) {
            return false;
        }
        ClientboundAddPaintingPacket other = (ClientboundAddPaintingPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        PaintingType this$paintingType = this.getPaintingType();
        PaintingType other$paintingType = other.getPaintingType();
        if (this$paintingType == null ? other$paintingType != null : !((Object)((Object)this$paintingType)).equals((Object)other$paintingType)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !this$direction.equals(other$direction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAddPaintingPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        PaintingType $paintingType = this.getPaintingType();
        result = result * 59 + ($paintingType == null ? 43 : ((Object)((Object)$paintingType)).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAddPaintingPacket(entityId=" + this.getEntityId() + ", uuid=" + this.getUuid() + ", paintingType=" + (Object)((Object)this.getPaintingType()) + ", position=" + this.getPosition() + ", direction=" + this.getDirection() + ")";
    }

    public ClientboundAddPaintingPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAddPaintingPacket(entityId, this.uuid, this.paintingType, this.position, this.direction);
    }

    public ClientboundAddPaintingPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ClientboundAddPaintingPacket(this.entityId, uuid, this.paintingType, this.position, this.direction);
    }

    public ClientboundAddPaintingPacket withPaintingType(@NonNull PaintingType paintingType) {
        if (paintingType == null) {
            throw new NullPointerException("paintingType is marked non-null but is null");
        }
        return this.paintingType == paintingType ? this : new ClientboundAddPaintingPacket(this.entityId, this.uuid, paintingType, this.position, this.direction);
    }

    public ClientboundAddPaintingPacket withPosition(@NonNull Position position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundAddPaintingPacket(this.entityId, this.uuid, this.paintingType, position, this.direction);
    }

    public ClientboundAddPaintingPacket withDirection(@NonNull Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        return this.direction == direction ? this : new ClientboundAddPaintingPacket(this.entityId, this.uuid, this.paintingType, this.position, direction);
    }

    public ClientboundAddPaintingPacket(int entityId, @NonNull UUID uuid, @NonNull PaintingType paintingType, @NonNull Position position, @NonNull Direction direction) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (paintingType == null) {
            throw new NullPointerException("paintingType is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.paintingType = paintingType;
        this.position = position;
        this.direction = direction;
    }
}

