/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.entity.RotationOrigin;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundPlayerLookAtPacket
implements Packet {
    @NonNull
    private final RotationOrigin origin;
    private final double x;
    private final double y;
    private final double z;
    private final int targetEntityId;
    private final RotationOrigin targetEntityOrigin;

    public ClientboundPlayerLookAtPacket(RotationOrigin origin, double x, double y, double z) {
        this(origin, x, y, z, 0, null);
    }

    public ClientboundPlayerLookAtPacket(NetInput in) throws IOException {
        this.origin = MagicValues.key(RotationOrigin.class, in.readVarInt());
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        if (in.readBoolean()) {
            this.targetEntityId = in.readVarInt();
            this.targetEntityOrigin = MagicValues.key(RotationOrigin.class, in.readVarInt());
        } else {
            this.targetEntityId = 0;
            this.targetEntityOrigin = null;
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.origin).intValue());
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        if (this.targetEntityOrigin != null) {
            out.writeBoolean(true);
            out.writeVarInt(this.targetEntityId);
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.targetEntityOrigin).intValue());
        } else {
            out.writeBoolean(false);
        }
    }

    @NonNull
    public RotationOrigin getOrigin() {
        return this.origin;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    public RotationOrigin getTargetEntityOrigin() {
        return this.targetEntityOrigin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerLookAtPacket)) {
            return false;
        }
        ClientboundPlayerLookAtPacket other = (ClientboundPlayerLookAtPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (this.getTargetEntityId() != other.getTargetEntityId()) {
            return false;
        }
        RotationOrigin this$origin = this.getOrigin();
        RotationOrigin other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)((Object)this$origin)).equals((Object)other$origin)) {
            return false;
        }
        RotationOrigin this$targetEntityOrigin = this.getTargetEntityOrigin();
        RotationOrigin other$targetEntityOrigin = other.getTargetEntityOrigin();
        return !(this$targetEntityOrigin == null ? other$targetEntityOrigin != null : !((Object)((Object)this$targetEntityOrigin)).equals((Object)other$targetEntityOrigin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerLookAtPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + this.getTargetEntityId();
        RotationOrigin $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)((Object)$origin)).hashCode());
        RotationOrigin $targetEntityOrigin = this.getTargetEntityOrigin();
        result = result * 59 + ($targetEntityOrigin == null ? 43 : ((Object)((Object)$targetEntityOrigin)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundPlayerLookAtPacket(origin=" + (Object)((Object)this.getOrigin()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", targetEntityId=" + this.getTargetEntityId() + ", targetEntityOrigin=" + (Object)((Object)this.getTargetEntityOrigin()) + ")";
    }

    public ClientboundPlayerLookAtPacket withOrigin(@NonNull RotationOrigin origin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        return this.origin == origin ? this : new ClientboundPlayerLookAtPacket(origin, this.x, this.y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket withX(double x) {
        return this.x == x ? this : new ClientboundPlayerLookAtPacket(this.origin, x, this.y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket withY(double y) {
        return this.y == y ? this : new ClientboundPlayerLookAtPacket(this.origin, this.x, y, this.z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket withZ(double z) {
        return this.z == z ? this : new ClientboundPlayerLookAtPacket(this.origin, this.x, this.y, z, this.targetEntityId, this.targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket withTargetEntityId(int targetEntityId) {
        return this.targetEntityId == targetEntityId ? this : new ClientboundPlayerLookAtPacket(this.origin, this.x, this.y, this.z, targetEntityId, this.targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket withTargetEntityOrigin(RotationOrigin targetEntityOrigin) {
        return this.targetEntityOrigin == targetEntityOrigin ? this : new ClientboundPlayerLookAtPacket(this.origin, this.x, this.y, this.z, this.targetEntityId, targetEntityOrigin);
    }

    public ClientboundPlayerLookAtPacket(@NonNull RotationOrigin origin, double x, double y, double z, int targetEntityId, RotationOrigin targetEntityOrigin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        this.origin = origin;
        this.x = x;
        this.y = y;
        this.z = z;
        this.targetEntityId = targetEntityId;
        this.targetEntityOrigin = targetEntityOrigin;
    }
}

