/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.Arrays;
import lombok.NonNull;

public class ClientboundSetEntityDataPacket
implements Packet {
    private final int entityId;
    @NonNull
    private final EntityMetadata<?, ?>[] metadata;

    public ClientboundSetEntityDataPacket(NetInput in) throws IOException {
        this.entityId = in.readVarInt();
        this.metadata = EntityMetadata.read(in);
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.entityId);
        EntityMetadata.write(out, this.metadata);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public EntityMetadata<?, ?>[] getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEntityDataPacket)) {
            return false;
        }
        ClientboundSetEntityDataPacket other = (ClientboundSetEntityDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadata(), other.getMetadata());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetEntityDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + Arrays.deepHashCode(this.getMetadata());
        return result;
    }

    public String toString() {
        return "ClientboundSetEntityDataPacket(entityId=" + this.getEntityId() + ", metadata=" + Arrays.deepToString(this.getMetadata()) + ")";
    }

    public ClientboundSetEntityDataPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundSetEntityDataPacket(entityId, this.metadata);
    }

    public ClientboundSetEntityDataPacket withMetadata(@NonNull EntityMetadata<?, ?>[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata == metadata ? this : new ClientboundSetEntityDataPacket(this.entityId, metadata);
    }

    public ClientboundSetEntityDataPacket(int entityId, @NonNull EntityMetadata<?, ?>[] metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        this.entityId = entityId;
        this.metadata = metadata;
    }
}

