/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class ClientboundUpdateTagsPacket
implements Packet {
    @NonNull
    private final Map<String, Map<String, int[]>> tags = new HashMap<String, Map<String, int[]>>();

    public ClientboundUpdateTagsPacket(NetInput in) throws IOException {
        int totalTagCount = in.readVarInt();
        for (int i = 0; i < totalTagCount; ++i) {
            HashMap<String, int[]> tag = new HashMap<String, int[]>();
            String tagName = Identifier.formalize(in.readString());
            int tagsCount = in.readVarInt();
            for (int j = 0; j < tagsCount; ++j) {
                String name = in.readString();
                int entriesCount = in.readVarInt();
                int[] entries = new int[entriesCount];
                for (int index = 0; index < entriesCount; ++index) {
                    entries[index] = in.readVarInt();
                }
                tag.put(name, entries);
            }
            this.tags.put(tagName, tag);
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeVarInt(this.tags.size());
        for (Map.Entry<String, Map<String, int[]>> tagSet : this.tags.entrySet()) {
            out.writeString(tagSet.getKey());
            out.writeVarInt(tagSet.getValue().size());
            for (Map.Entry<String, int[]> tag : tagSet.getValue().entrySet()) {
                out.writeString(tag.getKey());
                out.writeVarInt(tag.getValue().length);
                for (int id : tag.getValue()) {
                    out.writeVarInt(id);
                }
            }
        }
    }

    @NonNull
    public Map<String, Map<String, int[]>> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateTagsPacket)) {
            return false;
        }
        ClientboundUpdateTagsPacket other = (ClientboundUpdateTagsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<String, int[]>> this$tags = this.getTags();
        Map<String, Map<String, int[]>> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateTagsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<String, int[]>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundUpdateTagsPacket(tags=" + this.getTags() + ")";
    }

    public ClientboundUpdateTagsPacket() {
    }
}

