/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.MagicValues;
import com.github.steveice10.mc.protocol.data.game.BossBarAction;
import com.github.steveice10.mc.protocol.data.game.BossBarColor;
import com.github.steveice10.mc.protocol.data.game.BossBarDivision;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import com.github.steveice10.packetlib.packet.Packet;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundBossEventPacket
implements Packet {
    @NonNull
    private final UUID uuid;
    @NonNull
    private final BossBarAction action;
    private final Component title;
    private final float health;
    private final BossBarColor color;
    private final BossBarDivision division;
    private final boolean darkenSky;
    private final boolean playEndMusic;
    private final boolean showFog;

    public ClientboundBossEventPacket(@NonNull UUID uuid) {
        this(uuid, BossBarAction.REMOVE, null, 0.0f, null, null, false, false, false);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
    }

    public ClientboundBossEventPacket(@NonNull UUID uuid, @NonNull Component title) {
        this(uuid, BossBarAction.UPDATE_TITLE, title, 0.0f, null, null, false, false, false);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
    }

    public ClientboundBossEventPacket(@NonNull UUID uuid, float health) {
        this(uuid, BossBarAction.UPDATE_HEALTH, null, health, null, null, false, false, false);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
    }

    public ClientboundBossEventPacket(@NonNull UUID uuid, @NonNull BossBarColor color, @NonNull BossBarDivision division) {
        this(uuid, BossBarAction.UPDATE_STYLE, null, 0.0f, color, division, false, false, false);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (division == null) {
            throw new NullPointerException("division is marked non-null but is null");
        }
    }

    public ClientboundBossEventPacket(@NonNull UUID uuid, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        this(uuid, BossBarAction.UPDATE_FLAGS, null, 0.0f, null, null, darkenSky, playEndMusic, showFog);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
    }

    public ClientboundBossEventPacket(@NonNull UUID uuid, @NonNull Component title, float health, @NonNull BossBarColor color, @NonNull BossBarDivision division, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (division == null) {
            throw new NullPointerException("division is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = BossBarAction.ADD;
        this.title = title;
        this.health = health;
        this.color = color;
        this.division = division;
        this.darkenSky = darkenSky;
        this.playEndMusic = playEndMusic;
        this.showFog = showFog;
    }

    public ClientboundBossEventPacket(NetInput in) throws IOException {
        this.uuid = in.readUUID();
        this.action = MagicValues.key(BossBarAction.class, in.readVarInt());
        this.title = this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_TITLE ? DefaultComponentSerializer.get().deserialize((Object)in.readString()) : null;
        this.health = this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_HEALTH ? in.readFloat() : 0.0f;
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_STYLE) {
            this.color = MagicValues.key(BossBarColor.class, in.readVarInt());
            this.division = MagicValues.key(BossBarDivision.class, in.readVarInt());
        } else {
            this.color = null;
            this.division = null;
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_FLAGS) {
            int flags = in.readUnsignedByte();
            this.darkenSky = (flags & 1) == 1;
            this.playEndMusic = (flags & 2) == 2;
            this.showFog = (flags & 4) == 4;
        } else {
            this.darkenSky = false;
            this.playEndMusic = false;
            this.showFog = false;
        }
    }

    public void write(NetOutput out) throws IOException {
        out.writeUUID(this.uuid);
        out.writeVarInt(MagicValues.value(Integer.class, (Object)this.action).intValue());
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_TITLE) {
            out.writeString((String)DefaultComponentSerializer.get().serialize(this.title));
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_HEALTH) {
            out.writeFloat(this.health);
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_STYLE) {
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.color).intValue());
            out.writeVarInt(MagicValues.value(Integer.class, (Object)this.division).intValue());
        }
        if (this.action == BossBarAction.ADD || this.action == BossBarAction.UPDATE_FLAGS) {
            int flags = 0;
            if (this.darkenSky) {
                flags |= 1;
            }
            if (this.playEndMusic) {
                flags |= 2;
            }
            if (this.showFog) {
                flags |= 4;
            }
            out.writeByte(flags);
        }
    }

    @NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NonNull
    public BossBarAction getAction() {
        return this.action;
    }

    public Component getTitle() {
        return this.title;
    }

    public float getHealth() {
        return this.health;
    }

    public BossBarColor getColor() {
        return this.color;
    }

    public BossBarDivision getDivision() {
        return this.division;
    }

    public boolean isDarkenSky() {
        return this.darkenSky;
    }

    public boolean isPlayEndMusic() {
        return this.playEndMusic;
    }

    public boolean isShowFog() {
        return this.showFog;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBossEventPacket)) {
            return false;
        }
        ClientboundBossEventPacket other = (ClientboundBossEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getHealth(), other.getHealth()) != 0) {
            return false;
        }
        if (this.isDarkenSky() != other.isDarkenSky()) {
            return false;
        }
        if (this.isPlayEndMusic() != other.isPlayEndMusic()) {
            return false;
        }
        if (this.isShowFog() != other.isShowFog()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        BossBarAction this$action = this.getAction();
        BossBarAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$title = this.getTitle();
        Component other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        BossBarColor this$color = this.getColor();
        BossBarColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        BossBarDivision this$division = this.getDivision();
        BossBarDivision other$division = other.getDivision();
        return !(this$division == null ? other$division != null : !((Object)((Object)this$division)).equals((Object)other$division));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundBossEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getHealth());
        result = result * 59 + (this.isDarkenSky() ? 79 : 97);
        result = result * 59 + (this.isPlayEndMusic() ? 79 : 97);
        result = result * 59 + (this.isShowFog() ? 79 : 97);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        BossBarAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        BossBarColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        BossBarDivision $division = this.getDivision();
        result = result * 59 + ($division == null ? 43 : ((Object)((Object)$division)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundBossEventPacket(uuid=" + this.getUuid() + ", action=" + (Object)((Object)this.getAction()) + ", title=" + this.getTitle() + ", health=" + this.getHealth() + ", color=" + (Object)((Object)this.getColor()) + ", division=" + (Object)((Object)this.getDivision()) + ", darkenSky=" + this.isDarkenSky() + ", playEndMusic=" + this.isPlayEndMusic() + ", showFog=" + this.isShowFog() + ")";
    }

    public ClientboundBossEventPacket withUuid(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ClientboundBossEventPacket(uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withAction(@NonNull BossBarAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundBossEventPacket(this.uuid, action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withTitle(Component title) {
        return this.title == title ? this : new ClientboundBossEventPacket(this.uuid, this.action, title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withHealth(float health) {
        return this.health == health ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, health, this.color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withColor(BossBarColor color) {
        return this.color == color ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, this.health, color, this.division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withDivision(BossBarDivision division) {
        return this.division == division ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, this.health, this.color, division, this.darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withDarkenSky(boolean darkenSky) {
        return this.darkenSky == darkenSky ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, darkenSky, this.playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withPlayEndMusic(boolean playEndMusic) {
        return this.playEndMusic == playEndMusic ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, playEndMusic, this.showFog);
    }

    public ClientboundBossEventPacket withShowFog(boolean showFog) {
        return this.showFog == showFog ? this : new ClientboundBossEventPacket(this.uuid, this.action, this.title, this.health, this.color, this.division, this.darkenSky, this.playEndMusic, showFog);
    }

    private ClientboundBossEventPacket(@NonNull UUID uuid, @NonNull BossBarAction action, Component title, float health, BossBarColor color, BossBarDivision division, boolean darkenSky, boolean playEndMusic, boolean showFog) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.uuid = uuid;
        this.action = action;
        this.title = title;
        this.health = health;
        this.color = color;
        this.division = division;
        this.darkenSky = darkenSky;
        this.playEndMusic = playEndMusic;
        this.showFog = showFog;
    }
}

