/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.status;

import com.github.steveice10.mc.auth.data.GameProfile;
import java.util.Arrays;
import lombok.NonNull;

public class PlayerInfo {
    private int maxPlayers;
    private int onlinePlayers;
    @NonNull
    private GameProfile[] players;

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    @NonNull
    public GameProfile[] getPlayers() {
        return this.players;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerInfo)) {
            return false;
        }
        PlayerInfo other = (PlayerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getOnlinePlayers() != other.getOnlinePlayers()) {
            return false;
        }
        return Arrays.deepEquals(this.getPlayers(), other.getPlayers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getOnlinePlayers();
        result = result * 59 + Arrays.deepHashCode(this.getPlayers());
        return result;
    }

    public String toString() {
        return "PlayerInfo(maxPlayers=" + this.getMaxPlayers() + ", onlinePlayers=" + this.getOnlinePlayers() + ", players=" + Arrays.deepToString(this.getPlayers()) + ")";
    }

    public PlayerInfo(int maxPlayers, int onlinePlayers, @NonNull GameProfile[] players) {
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        this.maxPlayers = maxPlayers;
        this.onlinePlayers = onlinePlayers;
        this.players = players;
    }
}

