/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.level.particle;

import com.github.steveice10.mc.protocol.data.game.level.particle.ParticleData;
import com.github.steveice10.mc.protocol.data.game.level.particle.ParticleType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import lombok.NonNull;

public class Particle {
    @NonNull
    private final ParticleType type;
    private final ParticleData data;

    public static Particle read(NetInput in) throws IOException {
        ParticleType particleType = (ParticleType)in.readEnum((Enum[])ParticleType.VALUES);
        return new Particle(particleType, ParticleData.read(in, particleType));
    }

    public static void write(NetOutput out, Particle particle) throws IOException {
        out.writeEnum((Enum)particle.getType());
        ParticleData.write(out, particle.getType(), particle.getData());
    }

    @NonNull
    public ParticleType getType() {
        return this.type;
    }

    public ParticleData getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Particle)) {
            return false;
        }
        Particle other = (Particle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParticleType this$type = this.getType();
        ParticleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ParticleData this$data = this.getData();
        ParticleData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Particle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParticleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ParticleData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Particle(type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
    }

    public Particle(@NonNull ParticleType type, ParticleData data) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.data = data;
    }
}

