/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata.type;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.EntityMetadata;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.FloatMetadataType;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import lombok.NonNull;

public class FloatEntityMetadata
extends EntityMetadata<Float, FloatMetadataType> {
    private final float value;

    public FloatEntityMetadata(int id, @NonNull FloatMetadataType type, float value) {
        super(id, type);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.value = value;
    }

    public float getPrimitiveValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    protected void write(NetOutput out) throws IOException {
        ((FloatMetadataType)this.type).writeMetadataPrimitive(out, this.value);
    }
}

