/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.entity.metadata;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.MetadataType;
import com.github.steveice10.packetlib.io.NetInput;
import com.github.steveice10.packetlib.io.NetOutput;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntMetadataType
extends MetadataType<OptionalInt> {
    protected OptionalIntMetadataType(MetadataType.EntityMetadataFactory<OptionalInt> metadataFactory) {
        super(OptionalIntReader.INSTANCE, OptionalIntWriter.INSTANCE, metadataFactory);
    }

    public static class OptionalIntWriter
    implements MetadataType.Writer<OptionalInt> {
        protected static final OptionalIntWriter INSTANCE = new OptionalIntWriter();

        @Override
        public void write(NetOutput output, OptionalInt value) throws IOException {
            if (value.isPresent()) {
                output.writeVarInt(value.getAsInt() + 1);
            } else {
                output.writeVarInt(0);
            }
        }
    }

    public static class OptionalIntReader
    implements MetadataType.Reader<OptionalInt> {
        protected static final OptionalIntReader INSTANCE = new OptionalIntReader();

        @Override
        public OptionalInt read(NetInput input) throws IOException {
            int value = input.readVarInt();
            if (value == 0) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(value - 1);
        }
    }
}

