/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.data.game.chunk.palette;

import com.github.steveice10.mc.protocol.data.game.chunk.palette.Palette;
import com.github.steveice10.packetlib.io.NetInput;
import java.io.IOException;
import java.util.Arrays;

public class ListPalette
implements Palette {
    private final int maxId;
    private final int[] data;
    private int nextId = 0;

    public ListPalette(int bitsPerEntry) {
        this.maxId = (1 << bitsPerEntry) - 1;
        this.data = new int[this.maxId + 1];
    }

    public ListPalette(int bitsPerEntry, NetInput in) throws IOException {
        this(bitsPerEntry);
        int paletteLength = in.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            this.data[i] = in.readVarInt();
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        int id = -1;
        for (int i = 0; i < this.nextId; ++i) {
            if (this.data[i] != state) continue;
            id = i;
            break;
        }
        if (id == -1 && this.size() < this.maxId + 1) {
            id = this.nextId++;
            this.data[id] = state;
        }
        return id;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.data[id];
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPalette)) {
            return false;
        }
        ListPalette other = (ListPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxId != other.maxId) {
            return false;
        }
        if (this.nextId != other.nextId) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxId;
        result = result * 59 + this.nextId;
        result = result * 59 + Arrays.hashCode(this.data);
        return result;
    }
}

