/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.login.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundLoginFinishedPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final GameProfile profile;

    public ClientboundLoginFinishedPacket(ByteBuf in, MinecraftCodecHelper helper) {
        GameProfile profile = new GameProfile(helper.readUUID(in), helper.readString(in));
        profile.setProperties(helper.readList(in, helper::readProperty));
        this.profile = profile;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeUUID(out, this.profile.getId());
        helper.writeString(out, this.profile.getName());
        helper.writeList(out, this.profile.getProperties(), helper::writeProperty);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @lombok.NonNull
    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLoginFinishedPacket)) {
            return false;
        }
        ClientboundLoginFinishedPacket other = (ClientboundLoginFinishedPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameProfile this$profile = this.getProfile();
        GameProfile other$profile = other.getProfile();
        return !(this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundLoginFinishedPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameProfile $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundLoginFinishedPacket(profile=" + this.getProfile() + ")";
    }

    public @NonNull ClientboundLoginFinishedPacket withProfile(@lombok.NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.profile == profile ? this : new ClientboundLoginFinishedPacket(profile);
    }

    public ClientboundLoginFinishedPacket(@lombok.NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.profile = profile;
    }
}

