/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.login.clientbound;

import io.netty.buffer.ByteBuf;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundHelloPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String serverId;
    @lombok.NonNull
    private final PublicKey publicKey;
    private final byte @lombok.NonNull [] challenge;
    private final boolean shouldAuthenticate;

    public ClientboundHelloPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.serverId = helper.readString(in);
        byte[] publicKey = helper.readByteArray(in);
        this.challenge = helper.readByteArray(in);
        this.shouldAuthenticate = in.readBoolean();
        try {
            this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not decode public key.", e);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.serverId);
        byte[] encoded = this.publicKey.getEncoded();
        helper.writeByteArray(out, encoded);
        helper.writeByteArray(out, this.challenge);
        out.writeBoolean(this.shouldAuthenticate);
    }

    @lombok.NonNull
    public String getServerId() {
        return this.serverId;
    }

    @lombok.NonNull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte @lombok.NonNull [] getChallenge() {
        return this.challenge;
    }

    public boolean isShouldAuthenticate() {
        return this.shouldAuthenticate;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundHelloPacket)) {
            return false;
        }
        ClientboundHelloPacket other = (ClientboundHelloPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShouldAuthenticate() != other.isShouldAuthenticate()) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        return Arrays.equals(this.getChallenge(), other.getChallenge());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundHelloPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldAuthenticate() ? 79 : 97);
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getChallenge());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundHelloPacket(serverId=" + this.getServerId() + ", publicKey=" + this.getPublicKey() + ", challenge=" + Arrays.toString(this.getChallenge()) + ", shouldAuthenticate=" + this.isShouldAuthenticate() + ")";
    }

    public @NonNull ClientboundHelloPacket withServerId(@lombok.NonNull String serverId) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        return this.serverId == serverId ? this : new ClientboundHelloPacket(serverId, this.publicKey, this.challenge, this.shouldAuthenticate);
    }

    public @NonNull ClientboundHelloPacket withPublicKey(@lombok.NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.publicKey == publicKey ? this : new ClientboundHelloPacket(this.serverId, publicKey, this.challenge, this.shouldAuthenticate);
    }

    public @NonNull ClientboundHelloPacket withChallenge(byte @lombok.NonNull [] challenge) {
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        return this.challenge == challenge ? this : new ClientboundHelloPacket(this.serverId, this.publicKey, challenge, this.shouldAuthenticate);
    }

    public @NonNull ClientboundHelloPacket withShouldAuthenticate(boolean shouldAuthenticate) {
        return this.shouldAuthenticate == shouldAuthenticate ? this : new ClientboundHelloPacket(this.serverId, this.publicKey, this.challenge, shouldAuthenticate);
    }

    public ClientboundHelloPacket(@lombok.NonNull String serverId, @lombok.NonNull PublicKey publicKey, byte @lombok.NonNull [] challenge, boolean shouldAuthenticate) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.challenge = challenge;
        this.shouldAuthenticate = shouldAuthenticate;
    }
}

