/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ServerboundUseItemPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Hand hand;
    private final int sequence;
    private final float yRot;
    private final float xRot;

    public ServerboundUseItemPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.hand = Hand.from(helper.readVarInt(in));
        this.sequence = helper.readVarInt(in);
        this.yRot = in.readFloat();
        this.xRot = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.hand.ordinal());
        helper.writeVarInt(out, this.sequence);
        out.writeFloat(this.yRot);
        out.writeFloat(this.xRot);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Hand getHand() {
        return this.hand;
    }

    public int getSequence() {
        return this.sequence;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundUseItemPacket)) {
            return false;
        }
        ServerboundUseItemPacket other = (ServerboundUseItemPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        if (Float.compare(this.getYRot(), other.getYRot()) != 0) {
            return false;
        }
        if (Float.compare(this.getXRot(), other.getXRot()) != 0) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundUseItemPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        result = result * 59 + Float.floatToIntBits(this.getYRot());
        result = result * 59 + Float.floatToIntBits(this.getXRot());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundUseItemPacket(hand=" + this.getHand() + ", sequence=" + this.getSequence() + ", yRot=" + this.getYRot() + ", xRot=" + this.getXRot() + ")";
    }

    public @NonNull ServerboundUseItemPacket withHand(@lombok.NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ServerboundUseItemPacket(hand, this.sequence, this.yRot, this.xRot);
    }

    public @NonNull ServerboundUseItemPacket withSequence(int sequence) {
        return this.sequence == sequence ? this : new ServerboundUseItemPacket(this.hand, sequence, this.yRot, this.xRot);
    }

    public @NonNull ServerboundUseItemPacket withYRot(float yRot) {
        return this.yRot == yRot ? this : new ServerboundUseItemPacket(this.hand, this.sequence, yRot, this.xRot);
    }

    public @NonNull ServerboundUseItemPacket withXRot(float xRot) {
        return this.xRot == xRot ? this : new ServerboundUseItemPacket(this.hand, this.sequence, this.yRot, xRot);
    }

    public ServerboundUseItemPacket(@lombok.NonNull Hand hand, int sequence, float yRot, float xRot) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.hand = hand;
        this.sequence = sequence;
        this.yRot = yRot;
        this.xRot = xRot;
    }
}

