/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPlayerInputPacket
implements MinecraftPacket {
    private static final byte FLAG_FORWARD = 1;
    private static final byte FLAG_BACKWARD = 2;
    private static final byte FLAG_LEFT = 4;
    private static final byte FLAG_RIGHT = 8;
    private static final byte FLAG_JUMP = 16;
    private static final byte FLAG_SHIFT = 32;
    private static final byte FLAG_SPRINT = 64;
    private final boolean forward;
    private final boolean backward;
    private final boolean left;
    private final boolean right;
    private final boolean jump;
    private final boolean shift;
    private final boolean sprint;

    public ServerboundPlayerInputPacket(ByteBuf in, MinecraftCodecHelper helper) {
        byte flags = in.readByte();
        this.forward = (flags & 1) != 0;
        this.backward = (flags & 2) != 0;
        this.left = (flags & 4) != 0;
        this.right = (flags & 8) != 0;
        this.jump = (flags & 0x10) != 0;
        this.shift = (flags & 0x20) != 0;
        this.sprint = (flags & 0x40) != 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        byte flags = 0;
        if (this.forward) {
            flags = (byte)(flags | 1);
        }
        if (this.backward) {
            flags = (byte)(flags | 2);
        }
        if (this.left) {
            flags = (byte)(flags | 4);
        }
        if (this.right) {
            flags = (byte)(flags | 8);
        }
        if (this.jump) {
            flags = (byte)(flags | 0x10);
        }
        if (this.shift) {
            flags = (byte)(flags | 0x20);
        }
        if (this.sprint) {
            flags = (byte)(flags | 0x40);
        }
        out.writeByte((int)flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public boolean isLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean isJump() {
        return this.jump;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isSprint() {
        return this.sprint;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerInputPacket)) {
            return false;
        }
        ServerboundPlayerInputPacket other = (ServerboundPlayerInputPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForward() != other.isForward()) {
            return false;
        }
        if (this.isBackward() != other.isBackward()) {
            return false;
        }
        if (this.isLeft() != other.isLeft()) {
            return false;
        }
        if (this.isRight() != other.isRight()) {
            return false;
        }
        if (this.isJump() != other.isJump()) {
            return false;
        }
        if (this.isShift() != other.isShift()) {
            return false;
        }
        return this.isSprint() == other.isSprint();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPlayerInputPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForward() ? 79 : 97);
        result = result * 59 + (this.isBackward() ? 79 : 97);
        result = result * 59 + (this.isLeft() ? 79 : 97);
        result = result * 59 + (this.isRight() ? 79 : 97);
        result = result * 59 + (this.isJump() ? 79 : 97);
        result = result * 59 + (this.isShift() ? 79 : 97);
        result = result * 59 + (this.isSprint() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPlayerInputPacket(forward=" + this.isForward() + ", backward=" + this.isBackward() + ", left=" + this.isLeft() + ", right=" + this.isRight() + ", jump=" + this.isJump() + ", shift=" + this.isShift() + ", sprint=" + this.isSprint() + ")";
    }

    public @NonNull ServerboundPlayerInputPacket withForward(boolean forward) {
        return this.forward == forward ? this : new ServerboundPlayerInputPacket(forward, this.backward, this.left, this.right, this.jump, this.shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withBackward(boolean backward) {
        return this.backward == backward ? this : new ServerboundPlayerInputPacket(this.forward, backward, this.left, this.right, this.jump, this.shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withLeft(boolean left) {
        return this.left == left ? this : new ServerboundPlayerInputPacket(this.forward, this.backward, left, this.right, this.jump, this.shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withRight(boolean right) {
        return this.right == right ? this : new ServerboundPlayerInputPacket(this.forward, this.backward, this.left, right, this.jump, this.shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withJump(boolean jump) {
        return this.jump == jump ? this : new ServerboundPlayerInputPacket(this.forward, this.backward, this.left, this.right, jump, this.shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withShift(boolean shift) {
        return this.shift == shift ? this : new ServerboundPlayerInputPacket(this.forward, this.backward, this.left, this.right, this.jump, shift, this.sprint);
    }

    public @NonNull ServerboundPlayerInputPacket withSprint(boolean sprint) {
        return this.sprint == sprint ? this : new ServerboundPlayerInputPacket(this.forward, this.backward, this.left, this.right, this.jump, this.shift, sprint);
    }

    public ServerboundPlayerInputPacket(boolean forward, boolean backward, boolean left, boolean right, boolean jump, boolean shift, boolean sprint) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.jump = jump;
        this.shift = shift;
        this.sprint = sprint;
    }
}

