/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPaddleBoatPacket
implements MinecraftPacket {
    private final boolean rightPaddleTurning;
    private final boolean leftPaddleTurning;

    public ServerboundPaddleBoatPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.rightPaddleTurning = in.readBoolean();
        this.leftPaddleTurning = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeBoolean(this.rightPaddleTurning);
        out.writeBoolean(this.leftPaddleTurning);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isRightPaddleTurning() {
        return this.rightPaddleTurning;
    }

    public boolean isLeftPaddleTurning() {
        return this.leftPaddleTurning;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPaddleBoatPacket)) {
            return false;
        }
        ServerboundPaddleBoatPacket other = (ServerboundPaddleBoatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRightPaddleTurning() != other.isRightPaddleTurning()) {
            return false;
        }
        return this.isLeftPaddleTurning() == other.isLeftPaddleTurning();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPaddleBoatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRightPaddleTurning() ? 79 : 97);
        result = result * 59 + (this.isLeftPaddleTurning() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPaddleBoatPacket(rightPaddleTurning=" + this.isRightPaddleTurning() + ", leftPaddleTurning=" + this.isLeftPaddleTurning() + ")";
    }

    public @NonNull ServerboundPaddleBoatPacket withRightPaddleTurning(boolean rightPaddleTurning) {
        return this.rightPaddleTurning == rightPaddleTurning ? this : new ServerboundPaddleBoatPacket(rightPaddleTurning, this.leftPaddleTurning);
    }

    public @NonNull ServerboundPaddleBoatPacket withLeftPaddleTurning(boolean leftPaddleTurning) {
        return this.leftPaddleTurning == leftPaddleTurning ? this : new ServerboundPaddleBoatPacket(this.rightPaddleTurning, leftPaddleTurning);
    }

    public ServerboundPaddleBoatPacket(boolean rightPaddleTurning, boolean leftPaddleTurning) {
        this.rightPaddleTurning = rightPaddleTurning;
        this.leftPaddleTurning = leftPaddleTurning;
    }
}

