/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundSelectTradePacket
implements MinecraftPacket {
    private final int slot;

    public ServerboundSelectTradePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.slot = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.slot);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSelectTradePacket)) {
            return false;
        }
        ServerboundSelectTradePacket other = (ServerboundSelectTradePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSlot() == other.getSlot();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSelectTradePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSelectTradePacket(slot=" + this.getSlot() + ")";
    }

    public @NonNull ServerboundSelectTradePacket withSlot(int slot) {
        return this.slot == slot ? this : new ServerboundSelectTradePacket(slot);
    }

    public ServerboundSelectTradePacket(int slot) {
        this.slot = slot;
    }
}

