/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.CraftingBookStateType;

public class ServerboundRecipeBookChangeSettingsPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final CraftingBookStateType type;
    private final boolean bookOpen;
    private final boolean filterActive;

    public ServerboundRecipeBookChangeSettingsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.type = CraftingBookStateType.from(helper.readVarInt(in));
        this.bookOpen = in.readBoolean();
        this.filterActive = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.type.ordinal());
        out.writeBoolean(this.bookOpen);
        out.writeBoolean(this.filterActive);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public CraftingBookStateType getType() {
        return this.type;
    }

    public boolean isBookOpen() {
        return this.bookOpen;
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundRecipeBookChangeSettingsPacket)) {
            return false;
        }
        ServerboundRecipeBookChangeSettingsPacket other = (ServerboundRecipeBookChangeSettingsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBookOpen() != other.isBookOpen()) {
            return false;
        }
        if (this.isFilterActive() != other.isFilterActive()) {
            return false;
        }
        CraftingBookStateType this$type = this.getType();
        CraftingBookStateType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundRecipeBookChangeSettingsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBookOpen() ? 79 : 97);
        result = result * 59 + (this.isFilterActive() ? 79 : 97);
        CraftingBookStateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundRecipeBookChangeSettingsPacket(type=" + this.getType() + ", bookOpen=" + this.isBookOpen() + ", filterActive=" + this.isFilterActive() + ")";
    }

    public @NonNull ServerboundRecipeBookChangeSettingsPacket withType(@lombok.NonNull CraftingBookStateType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ServerboundRecipeBookChangeSettingsPacket(type, this.bookOpen, this.filterActive);
    }

    public @NonNull ServerboundRecipeBookChangeSettingsPacket withBookOpen(boolean bookOpen) {
        return this.bookOpen == bookOpen ? this : new ServerboundRecipeBookChangeSettingsPacket(this.type, bookOpen, this.filterActive);
    }

    public @NonNull ServerboundRecipeBookChangeSettingsPacket withFilterActive(boolean filterActive) {
        return this.filterActive == filterActive ? this : new ServerboundRecipeBookChangeSettingsPacket(this.type, this.bookOpen, filterActive);
    }

    public ServerboundRecipeBookChangeSettingsPacket(@lombok.NonNull CraftingBookStateType type, boolean bookOpen, boolean filterActive) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.bookOpen = bookOpen;
        this.filterActive = filterActive;
    }
}

