/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPickItemFromEntityPacket
implements MinecraftPacket {
    private final int id;
    private final boolean includeData;

    public ServerboundPickItemFromEntityPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.id = helper.readVarInt(in);
        this.includeData = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.id);
        out.writeBoolean(this.includeData);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public boolean isIncludeData() {
        return this.includeData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPickItemFromEntityPacket)) {
            return false;
        }
        ServerboundPickItemFromEntityPacket other = (ServerboundPickItemFromEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.isIncludeData() == other.isIncludeData();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPickItemFromEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + (this.isIncludeData() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPickItemFromEntityPacket(id=" + this.getId() + ", includeData=" + this.isIncludeData() + ")";
    }

    public @NonNull ServerboundPickItemFromEntityPacket withId(int id) {
        return this.id == id ? this : new ServerboundPickItemFromEntityPacket(id, this.includeData);
    }

    public @NonNull ServerboundPickItemFromEntityPacket withIncludeData(boolean includeData) {
        return this.includeData == includeData ? this : new ServerboundPickItemFromEntityPacket(this.id, includeData);
    }

    public ServerboundPickItemFromEntityPacket(int id, boolean includeData) {
        this.id = id;
        this.includeData = includeData;
    }
}

