/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundCommandSuggestionPacket
implements MinecraftPacket {
    private final int transactionId;
    @lombok.NonNull
    private final String text;

    public ServerboundCommandSuggestionPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.text = helper.readString(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writeString(out, this.text);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    @lombok.NonNull
    public String getText() {
        return this.text;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundCommandSuggestionPacket)) {
            return false;
        }
        ServerboundCommandSuggestionPacket other = (ServerboundCommandSuggestionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundCommandSuggestionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundCommandSuggestionPacket(transactionId=" + this.getTransactionId() + ", text=" + this.getText() + ")";
    }

    public @NonNull ServerboundCommandSuggestionPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ServerboundCommandSuggestionPacket(transactionId, this.text);
    }

    public @NonNull ServerboundCommandSuggestionPacket withText(@lombok.NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.text == text ? this : new ServerboundCommandSuggestionPacket(this.transactionId, text);
    }

    public ServerboundCommandSuggestionPacket(int transactionId, @lombok.NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.transactionId = transactionId;
        this.text = text;
    }
}

