/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;

public class ClientboundSetDisplayObjectivePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final ScoreboardPosition position;
    @lombok.NonNull
    private final String name;

    public ClientboundSetDisplayObjectivePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.position = ScoreboardPosition.from(helper.readVarInt(in));
        this.name = helper.readString(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.position.ordinal());
        helper.writeString(out, this.name);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public ScoreboardPosition getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDisplayObjectivePacket)) {
            return false;
        }
        ClientboundSetDisplayObjectivePacket other = (ClientboundSetDisplayObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScoreboardPosition this$position = this.getPosition();
        ScoreboardPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetDisplayObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScoreboardPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetDisplayObjectivePacket(position=" + this.getPosition() + ", name=" + this.getName() + ")";
    }

    public @NonNull ClientboundSetDisplayObjectivePacket withPosition(@lombok.NonNull ScoreboardPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundSetDisplayObjectivePacket(position, this.name);
    }

    public @NonNull ClientboundSetDisplayObjectivePacket withName(@lombok.NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundSetDisplayObjectivePacket(this.position, name);
    }

    public ClientboundSetDisplayObjectivePacket(@lombok.NonNull ScoreboardPosition position, @lombok.NonNull String name) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.position = position;
        this.name = name;
    }
}

