/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.border;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetBorderLerpSizePacket
implements MinecraftPacket {
    private final double oldSize;
    private final double newSize;
    private final long lerpTime;

    public ClientboundSetBorderLerpSizePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.oldSize = in.readDouble();
        this.newSize = in.readDouble();
        this.lerpTime = helper.readVarLong(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeDouble(this.oldSize);
        out.writeDouble(this.newSize);
        helper.writeVarLong(out, this.lerpTime);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public double getOldSize() {
        return this.oldSize;
    }

    public double getNewSize() {
        return this.newSize;
    }

    public long getLerpTime() {
        return this.lerpTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetBorderLerpSizePacket)) {
            return false;
        }
        ClientboundSetBorderLerpSizePacket other = (ClientboundSetBorderLerpSizePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getOldSize(), other.getOldSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewSize(), other.getNewSize()) != 0) {
            return false;
        }
        return this.getLerpTime() == other.getLerpTime();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetBorderLerpSizePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $oldSize = Double.doubleToLongBits(this.getOldSize());
        result = result * 59 + (int)($oldSize >>> 32 ^ $oldSize);
        long $newSize = Double.doubleToLongBits(this.getNewSize());
        result = result * 59 + (int)($newSize >>> 32 ^ $newSize);
        long $lerpTime = this.getLerpTime();
        result = result * 59 + (int)($lerpTime >>> 32 ^ $lerpTime);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetBorderLerpSizePacket(oldSize=" + this.getOldSize() + ", newSize=" + this.getNewSize() + ", lerpTime=" + this.getLerpTime() + ")";
    }

    public @NonNull ClientboundSetBorderLerpSizePacket withOldSize(double oldSize) {
        return this.oldSize == oldSize ? this : new ClientboundSetBorderLerpSizePacket(oldSize, this.newSize, this.lerpTime);
    }

    public @NonNull ClientboundSetBorderLerpSizePacket withNewSize(double newSize) {
        return this.newSize == newSize ? this : new ClientboundSetBorderLerpSizePacket(this.oldSize, newSize, this.lerpTime);
    }

    public @NonNull ClientboundSetBorderLerpSizePacket withLerpTime(long lerpTime) {
        return this.lerpTime == lerpTime ? this : new ClientboundSetBorderLerpSizePacket(this.oldSize, this.newSize, lerpTime);
    }

    public ClientboundSetBorderLerpSizePacket(double oldSize, double newSize, long lerpTime) {
        this.oldSize = oldSize;
        this.newSize = newSize;
        this.lerpTime = lerpTime;
    }
}

