/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockChangeEntry;

public class ClientboundSectionBlocksUpdatePacket
implements MinecraftPacket {
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    @lombok.NonNull
    private final BlockChangeEntry[] entries;

    public ClientboundSectionBlocksUpdatePacket(int chunkX, int chunkY, int chunkZ, BlockChangeEntry ... entries) {
        if (entries == null || entries.length == 0) {
            throw new IllegalArgumentException("Entries must contain at least 1 value.");
        }
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.entries = entries;
    }

    public ClientboundSectionBlocksUpdatePacket(ByteBuf in, MinecraftCodecHelper helper) {
        long chunkPosition = in.readLong();
        this.chunkX = (int)(chunkPosition >> 42);
        this.chunkY = (int)(chunkPosition << 44 >> 44);
        this.chunkZ = (int)(chunkPosition << 22 >> 42);
        this.entries = new BlockChangeEntry[helper.readVarInt(in)];
        for (int index = 0; index < this.entries.length; ++index) {
            long blockData = helper.readVarLong(in);
            short position = (short)(blockData & 0xFFFL);
            int x = (this.chunkX << 4) + (position >>> 8 & 0xF);
            int y = (this.chunkY << 4) + (position & 0xF);
            int z = (this.chunkZ << 4) + (position >>> 4 & 0xF);
            this.entries[index] = new BlockChangeEntry(Vector3i.from((int)x, (int)y, (int)z), (int)(blockData >>> 12));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        long chunkPosition = 0L;
        chunkPosition |= ((long)this.chunkX & 0x3FFFFFL) << 42;
        out.writeLong((chunkPosition |= ((long)this.chunkZ & 0x3FFFFFL) << 20) | (long)this.chunkY & 0xFFFFFL);
        helper.writeVarInt(out, this.entries.length);
        for (BlockChangeEntry entry : this.entries) {
            short position = (short)(entry.getPosition().getX() - (this.chunkX << 4) << 8 | entry.getPosition().getZ() - (this.chunkZ << 4) << 4 | entry.getPosition().getY() - (this.chunkY << 4));
            helper.writeVarLong(out, (long)entry.getBlock() << 12 | (long)position);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    @lombok.NonNull
    public BlockChangeEntry[] getEntries() {
        return this.entries;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSectionBlocksUpdatePacket)) {
            return false;
        }
        ClientboundSectionBlocksUpdatePacket other = (ClientboundSectionBlocksUpdatePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChunkX() != other.getChunkX()) {
            return false;
        }
        if (this.getChunkY() != other.getChunkY()) {
            return false;
        }
        if (this.getChunkZ() != other.getChunkZ()) {
            return false;
        }
        return Arrays.deepEquals(this.getEntries(), other.getEntries());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSectionBlocksUpdatePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChunkX();
        result = result * 59 + this.getChunkY();
        result = result * 59 + this.getChunkZ();
        result = result * 59 + Arrays.deepHashCode(this.getEntries());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSectionBlocksUpdatePacket(chunkX=" + this.getChunkX() + ", chunkY=" + this.getChunkY() + ", chunkZ=" + this.getChunkZ() + ", entries=" + Arrays.deepToString(this.getEntries()) + ")";
    }

    public @NonNull ClientboundSectionBlocksUpdatePacket withChunkX(int chunkX) {
        return this.chunkX == chunkX ? this : new ClientboundSectionBlocksUpdatePacket(chunkX, this.chunkY, this.chunkZ, this.entries);
    }

    public @NonNull ClientboundSectionBlocksUpdatePacket withChunkY(int chunkY) {
        return this.chunkY == chunkY ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, chunkY, this.chunkZ, this.entries);
    }

    public @NonNull ClientboundSectionBlocksUpdatePacket withChunkZ(int chunkZ) {
        return this.chunkZ == chunkZ ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, this.chunkY, chunkZ, this.entries);
    }

    public @NonNull ClientboundSectionBlocksUpdatePacket withEntries(@lombok.NonNull BlockChangeEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return this.entries == entries ? this : new ClientboundSectionBlocksUpdatePacket(this.chunkX, this.chunkY, this.chunkZ, entries);
    }
}

