/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundForgetLevelChunkPacket
implements MinecraftPacket {
    private final int x;
    private final int z;

    public ClientboundForgetLevelChunkPacket(ByteBuf in, MinecraftCodecHelper helper) {
        long chunkPosition = in.readLong();
        this.x = (int)chunkPosition;
        this.z = (int)(chunkPosition >> 32);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeLong((long)this.x & 0xFFFFFFFFL | ((long)this.z & 0xFFFFFFFFL) << 32);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundForgetLevelChunkPacket)) {
            return false;
        }
        ClientboundForgetLevelChunkPacket other = (ClientboundForgetLevelChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundForgetLevelChunkPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundForgetLevelChunkPacket(x=" + this.getX() + ", z=" + this.getZ() + ")";
    }

    public @NonNull ClientboundForgetLevelChunkPacket withX(int x) {
        return this.x == x ? this : new ClientboundForgetLevelChunkPacket(x, this.z);
    }

    public @NonNull ClientboundForgetLevelChunkPacket withZ(int z) {
        return this.z == z ? this : new ClientboundForgetLevelChunkPacket(this.x, z);
    }

    public ClientboundForgetLevelChunkPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }
}

